/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.api;

import com.configcat.publicapi.java.client.ApiCallback;
import com.configcat.publicapi.java.client.ApiClient;
import com.configcat.publicapi.java.client.ApiException;
import com.configcat.publicapi.java.client.ApiResponse;
import com.configcat.publicapi.java.client.Configuration;
import com.configcat.publicapi.java.client.Pair;
import com.configcat.publicapi.java.client.model.CreateProductRequest;
import com.configcat.publicapi.java.client.model.PreferencesModel;
import com.configcat.publicapi.java.client.model.ProductModel;
import com.configcat.publicapi.java.client.model.UpdatePreferencesRequest;
import com.configcat.publicapi.java.client.model.UpdateProductRequest;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class ProductsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProductCall(UUID organizationId, CreateProductRequest createProductRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateProductRequest localVarPostBody = createProductRequest;
        String localVarPath = "/v1/organizations/{organizationId}/products".replace("{organizationId}", this.localVarApiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductValidateBeforeCall(UUID organizationId, CreateProductRequest createProductRequest, ApiCallback _callback) throws ApiException {
        if (organizationId == null) {
            throw new ApiException("Missing the required parameter 'organizationId' when calling createProduct(Async)");
        }
        if (createProductRequest == null) {
            throw new ApiException("Missing the required parameter 'createProductRequest' when calling createProduct(Async)");
        }
        return this.createProductCall(organizationId, createProductRequest, _callback);
    }

    public ProductModel createProduct(UUID organizationId, CreateProductRequest createProductRequest) throws ApiException {
        ApiResponse<ProductModel> localVarResp = this.createProductWithHttpInfo(organizationId, createProductRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ProductModel> createProductWithHttpInfo(UUID organizationId, CreateProductRequest createProductRequest) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(organizationId, createProductRequest, null);
        Type localVarReturnType = new TypeToken<ProductModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProductAsync(UUID organizationId, CreateProductRequest createProductRequest, ApiCallback<ProductModel> _callback) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(organizationId, createProductRequest, _callback);
        Type localVarReturnType = new TypeToken<ProductModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProductCall(UUID productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductValidateBeforeCall(UUID productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling deleteProduct(Async)");
        }
        return this.deleteProductCall(productId, _callback);
    }

    public void deleteProduct(UUID productId) throws ApiException {
        this.deleteProductWithHttpInfo(productId);
    }

    public ApiResponse<Void> deleteProductWithHttpInfo(UUID productId) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(productId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProductAsync(UUID productId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(productId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProductCall(UUID productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductValidateBeforeCall(UUID productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProduct(Async)");
        }
        return this.getProductCall(productId, _callback);
    }

    public ProductModel getProduct(UUID productId) throws ApiException {
        ApiResponse<ProductModel> localVarResp = this.getProductWithHttpInfo(productId);
        return localVarResp.getData();
    }

    public ApiResponse<ProductModel> getProductWithHttpInfo(UUID productId) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(productId, null);
        Type localVarReturnType = new TypeToken<ProductModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProductAsync(UUID productId, ApiCallback<ProductModel> _callback) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(productId, _callback);
        Type localVarReturnType = new TypeToken<ProductModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProductPreferencesCall(UUID productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}/preferences".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductPreferencesValidateBeforeCall(UUID productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProductPreferences(Async)");
        }
        return this.getProductPreferencesCall(productId, _callback);
    }

    public PreferencesModel getProductPreferences(UUID productId) throws ApiException {
        ApiResponse<PreferencesModel> localVarResp = this.getProductPreferencesWithHttpInfo(productId);
        return localVarResp.getData();
    }

    public ApiResponse<PreferencesModel> getProductPreferencesWithHttpInfo(UUID productId) throws ApiException {
        Call localVarCall = this.getProductPreferencesValidateBeforeCall(productId, null);
        Type localVarReturnType = new TypeToken<PreferencesModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProductPreferencesAsync(UUID productId, ApiCallback<PreferencesModel> _callback) throws ApiException {
        Call localVarCall = this.getProductPreferencesValidateBeforeCall(productId, _callback);
        Type localVarReturnType = new TypeToken<PreferencesModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProductsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getProductsCall(_callback);
    }

    public List<ProductModel> getProducts() throws ApiException {
        ApiResponse<List<ProductModel>> localVarResp = this.getProductsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<ProductModel>> getProductsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getProductsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<ProductModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProductsAsync(ApiCallback<List<ProductModel>> _callback) throws ApiException {
        Call localVarCall = this.getProductsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<ProductModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductCall(UUID productId, UpdateProductRequest updateProductRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateProductRequest localVarPostBody = updateProductRequest;
        String localVarPath = "/v1/products/{productId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductValidateBeforeCall(UUID productId, UpdateProductRequest updateProductRequest, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateProduct(Async)");
        }
        if (updateProductRequest == null) {
            throw new ApiException("Missing the required parameter 'updateProductRequest' when calling updateProduct(Async)");
        }
        return this.updateProductCall(productId, updateProductRequest, _callback);
    }

    public ProductModel updateProduct(UUID productId, UpdateProductRequest updateProductRequest) throws ApiException {
        ApiResponse<ProductModel> localVarResp = this.updateProductWithHttpInfo(productId, updateProductRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ProductModel> updateProductWithHttpInfo(UUID productId, UpdateProductRequest updateProductRequest) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(productId, updateProductRequest, null);
        Type localVarReturnType = new TypeToken<ProductModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductAsync(UUID productId, UpdateProductRequest updateProductRequest, ApiCallback<ProductModel> _callback) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(productId, updateProductRequest, _callback);
        Type localVarReturnType = new TypeToken<ProductModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductPreferencesCall(UUID productId, UpdatePreferencesRequest updatePreferencesRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePreferencesRequest localVarPostBody = updatePreferencesRequest;
        String localVarPath = "/v1/products/{productId}/preferences".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductPreferencesValidateBeforeCall(UUID productId, UpdatePreferencesRequest updatePreferencesRequest, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateProductPreferences(Async)");
        }
        if (updatePreferencesRequest == null) {
            throw new ApiException("Missing the required parameter 'updatePreferencesRequest' when calling updateProductPreferences(Async)");
        }
        return this.updateProductPreferencesCall(productId, updatePreferencesRequest, _callback);
    }

    public PreferencesModel updateProductPreferences(UUID productId, UpdatePreferencesRequest updatePreferencesRequest) throws ApiException {
        ApiResponse<PreferencesModel> localVarResp = this.updateProductPreferencesWithHttpInfo(productId, updatePreferencesRequest);
        return localVarResp.getData();
    }

    public ApiResponse<PreferencesModel> updateProductPreferencesWithHttpInfo(UUID productId, UpdatePreferencesRequest updatePreferencesRequest) throws ApiException {
        Call localVarCall = this.updateProductPreferencesValidateBeforeCall(productId, updatePreferencesRequest, null);
        Type localVarReturnType = new TypeToken<PreferencesModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductPreferencesAsync(UUID productId, UpdatePreferencesRequest updatePreferencesRequest, ApiCallback<PreferencesModel> _callback) throws ApiException {
        Call localVarCall = this.updateProductPreferencesValidateBeforeCall(productId, updatePreferencesRequest, _callback);
        Type localVarReturnType = new TypeToken<PreferencesModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

