/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.api;

import com.configcat.publicapi.java.client.ApiCallback;
import com.configcat.publicapi.java.client.ApiClient;
import com.configcat.publicapi.java.client.ApiException;
import com.configcat.publicapi.java.client.ApiResponse;
import com.configcat.publicapi.java.client.Configuration;
import com.configcat.publicapi.java.client.Pair;
import com.configcat.publicapi.java.client.model.CreateTagModel;
import com.configcat.publicapi.java.client.model.SettingModel;
import com.configcat.publicapi.java.client.model.TagModel;
import com.configcat.publicapi.java.client.model.UpdateTagModel;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class TagsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createTagCall(UUID productId, CreateTagModel createTagModel, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateTagModel localVarPostBody = createTagModel;
        String localVarPath = "/v1/products/{productId}/tags".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTagValidateBeforeCall(UUID productId, CreateTagModel createTagModel, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling createTag(Async)");
        }
        if (createTagModel == null) {
            throw new ApiException("Missing the required parameter 'createTagModel' when calling createTag(Async)");
        }
        return this.createTagCall(productId, createTagModel, _callback);
    }

    public TagModel createTag(UUID productId, CreateTagModel createTagModel) throws ApiException {
        ApiResponse<TagModel> localVarResp = this.createTagWithHttpInfo(productId, createTagModel);
        return localVarResp.getData();
    }

    public ApiResponse<TagModel> createTagWithHttpInfo(UUID productId, CreateTagModel createTagModel) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(productId, createTagModel, null);
        Type localVarReturnType = new TypeToken<TagModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTagAsync(UUID productId, CreateTagModel createTagModel, ApiCallback<TagModel> _callback) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(productId, createTagModel, _callback);
        Type localVarReturnType = new TypeToken<TagModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTagCall(Long tagId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/tags/{tagId}".replace("{tagId}", this.localVarApiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTagValidateBeforeCall(Long tagId, ApiCallback _callback) throws ApiException {
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling deleteTag(Async)");
        }
        return this.deleteTagCall(tagId, _callback);
    }

    public void deleteTag(Long tagId) throws ApiException {
        this.deleteTagWithHttpInfo(tagId);
    }

    public ApiResponse<Void> deleteTagWithHttpInfo(Long tagId) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(tagId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTagAsync(Long tagId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(tagId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSettingsByTagCall(Long tagId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/tags/{tagId}/settings".replace("{tagId}", this.localVarApiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSettingsByTagValidateBeforeCall(Long tagId, ApiCallback _callback) throws ApiException {
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling getSettingsByTag(Async)");
        }
        return this.getSettingsByTagCall(tagId, _callback);
    }

    public List<SettingModel> getSettingsByTag(Long tagId) throws ApiException {
        ApiResponse<List<SettingModel>> localVarResp = this.getSettingsByTagWithHttpInfo(tagId);
        return localVarResp.getData();
    }

    public ApiResponse<List<SettingModel>> getSettingsByTagWithHttpInfo(Long tagId) throws ApiException {
        Call localVarCall = this.getSettingsByTagValidateBeforeCall(tagId, null);
        Type localVarReturnType = new TypeToken<List<SettingModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSettingsByTagAsync(Long tagId, ApiCallback<List<SettingModel>> _callback) throws ApiException {
        Call localVarCall = this.getSettingsByTagValidateBeforeCall(tagId, _callback);
        Type localVarReturnType = new TypeToken<List<SettingModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTagCall(Long tagId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/tags/{tagId}".replace("{tagId}", this.localVarApiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTagValidateBeforeCall(Long tagId, ApiCallback _callback) throws ApiException {
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling getTag(Async)");
        }
        return this.getTagCall(tagId, _callback);
    }

    public TagModel getTag(Long tagId) throws ApiException {
        ApiResponse<TagModel> localVarResp = this.getTagWithHttpInfo(tagId);
        return localVarResp.getData();
    }

    public ApiResponse<TagModel> getTagWithHttpInfo(Long tagId) throws ApiException {
        Call localVarCall = this.getTagValidateBeforeCall(tagId, null);
        Type localVarReturnType = new TypeToken<TagModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTagAsync(Long tagId, ApiCallback<TagModel> _callback) throws ApiException {
        Call localVarCall = this.getTagValidateBeforeCall(tagId, _callback);
        Type localVarReturnType = new TypeToken<TagModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTagsCall(UUID productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}/tags".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTagsValidateBeforeCall(UUID productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getTags(Async)");
        }
        return this.getTagsCall(productId, _callback);
    }

    public List<TagModel> getTags(UUID productId) throws ApiException {
        ApiResponse<List<TagModel>> localVarResp = this.getTagsWithHttpInfo(productId);
        return localVarResp.getData();
    }

    public ApiResponse<List<TagModel>> getTagsWithHttpInfo(UUID productId) throws ApiException {
        Call localVarCall = this.getTagsValidateBeforeCall(productId, null);
        Type localVarReturnType = new TypeToken<List<TagModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTagsAsync(UUID productId, ApiCallback<List<TagModel>> _callback) throws ApiException {
        Call localVarCall = this.getTagsValidateBeforeCall(productId, _callback);
        Type localVarReturnType = new TypeToken<List<TagModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTagCall(Long tagId, UpdateTagModel updateTagModel, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateTagModel localVarPostBody = updateTagModel;
        String localVarPath = "/v1/tags/{tagId}".replace("{tagId}", this.localVarApiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTagValidateBeforeCall(Long tagId, UpdateTagModel updateTagModel, ApiCallback _callback) throws ApiException {
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling updateTag(Async)");
        }
        if (updateTagModel == null) {
            throw new ApiException("Missing the required parameter 'updateTagModel' when calling updateTag(Async)");
        }
        return this.updateTagCall(tagId, updateTagModel, _callback);
    }

    public TagModel updateTag(Long tagId, UpdateTagModel updateTagModel) throws ApiException {
        ApiResponse<TagModel> localVarResp = this.updateTagWithHttpInfo(tagId, updateTagModel);
        return localVarResp.getData();
    }

    public ApiResponse<TagModel> updateTagWithHttpInfo(Long tagId, UpdateTagModel updateTagModel) throws ApiException {
        Call localVarCall = this.updateTagValidateBeforeCall(tagId, updateTagModel, null);
        Type localVarReturnType = new TypeToken<TagModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTagAsync(Long tagId, UpdateTagModel updateTagModel, ApiCallback<TagModel> _callback) throws ApiException {
        Call localVarCall = this.updateTagValidateBeforeCall(tagId, updateTagModel, _callback);
        Type localVarReturnType = new TypeToken<TagModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

