/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.api;

import com.configcat.publicapi.java.client.ApiCallback;
import com.configcat.publicapi.java.client.ApiClient;
import com.configcat.publicapi.java.client.ApiException;
import com.configcat.publicapi.java.client.ApiResponse;
import com.configcat.publicapi.java.client.Configuration;
import com.configcat.publicapi.java.client.Pair;
import com.configcat.publicapi.java.client.model.JsonPatchOperation;
import com.configcat.publicapi.java.client.model.WebHookRequestModel;
import com.configcat.publicapi.java.client.model.WebhookResponseModel;
import com.configcat.publicapi.java.client.model.WebhookSigningKeysModel;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class WebhooksApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WebhooksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhooksApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createWebhookCall(UUID configId, UUID environmentId, WebHookRequestModel webHookRequestModel, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WebHookRequestModel localVarPostBody = webHookRequestModel;
        String localVarPath = "/v1/configs/{configId}/environments/{environmentId}/webhooks".replace("{configId}", this.localVarApiClient.escapeString(configId.toString())).replace("{environmentId}", this.localVarApiClient.escapeString(environmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createWebhookValidateBeforeCall(UUID configId, UUID environmentId, WebHookRequestModel webHookRequestModel, ApiCallback _callback) throws ApiException {
        if (configId == null) {
            throw new ApiException("Missing the required parameter 'configId' when calling createWebhook(Async)");
        }
        if (environmentId == null) {
            throw new ApiException("Missing the required parameter 'environmentId' when calling createWebhook(Async)");
        }
        if (webHookRequestModel == null) {
            throw new ApiException("Missing the required parameter 'webHookRequestModel' when calling createWebhook(Async)");
        }
        return this.createWebhookCall(configId, environmentId, webHookRequestModel, _callback);
    }

    public WebhookResponseModel createWebhook(UUID configId, UUID environmentId, WebHookRequestModel webHookRequestModel) throws ApiException {
        ApiResponse<WebhookResponseModel> localVarResp = this.createWebhookWithHttpInfo(configId, environmentId, webHookRequestModel);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookResponseModel> createWebhookWithHttpInfo(UUID configId, UUID environmentId, WebHookRequestModel webHookRequestModel) throws ApiException {
        Call localVarCall = this.createWebhookValidateBeforeCall(configId, environmentId, webHookRequestModel, null);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createWebhookAsync(UUID configId, UUID environmentId, WebHookRequestModel webHookRequestModel, ApiCallback<WebhookResponseModel> _callback) throws ApiException {
        Call localVarCall = this.createWebhookValidateBeforeCall(configId, environmentId, webHookRequestModel, _callback);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteWebhookCall(Integer webhookId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/webhooks/{webhookId}".replace("{webhookId}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWebhookValidateBeforeCall(Integer webhookId, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling deleteWebhook(Async)");
        }
        return this.deleteWebhookCall(webhookId, _callback);
    }

    public void deleteWebhook(Integer webhookId) throws ApiException {
        this.deleteWebhookWithHttpInfo(webhookId);
    }

    public ApiResponse<Void> deleteWebhookWithHttpInfo(Integer webhookId) throws ApiException {
        Call localVarCall = this.deleteWebhookValidateBeforeCall(webhookId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteWebhookAsync(Integer webhookId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWebhookValidateBeforeCall(webhookId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getWebhookCall(Integer webhookId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/webhooks/{webhookId}".replace("{webhookId}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWebhookValidateBeforeCall(Integer webhookId, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhook(Async)");
        }
        return this.getWebhookCall(webhookId, _callback);
    }

    public WebhookResponseModel getWebhook(Integer webhookId) throws ApiException {
        ApiResponse<WebhookResponseModel> localVarResp = this.getWebhookWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookResponseModel> getWebhookWithHttpInfo(Integer webhookId) throws ApiException {
        Call localVarCall = this.getWebhookValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWebhookAsync(Integer webhookId, ApiCallback<WebhookResponseModel> _callback) throws ApiException {
        Call localVarCall = this.getWebhookValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWebhookSigningKeysCall(Integer webhookId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/webhooks/{webhookId}/keys".replace("{webhookId}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWebhookSigningKeysValidateBeforeCall(Integer webhookId, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhookSigningKeys(Async)");
        }
        return this.getWebhookSigningKeysCall(webhookId, _callback);
    }

    public WebhookSigningKeysModel getWebhookSigningKeys(Integer webhookId) throws ApiException {
        ApiResponse<WebhookSigningKeysModel> localVarResp = this.getWebhookSigningKeysWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookSigningKeysModel> getWebhookSigningKeysWithHttpInfo(Integer webhookId) throws ApiException {
        Call localVarCall = this.getWebhookSigningKeysValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<WebhookSigningKeysModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWebhookSigningKeysAsync(Integer webhookId, ApiCallback<WebhookSigningKeysModel> _callback) throws ApiException {
        Call localVarCall = this.getWebhookSigningKeysValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<WebhookSigningKeysModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWebhooksCall(UUID productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}/webhooks".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWebhooksValidateBeforeCall(UUID productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getWebhooks(Async)");
        }
        return this.getWebhooksCall(productId, _callback);
    }

    public List<WebhookResponseModel> getWebhooks(UUID productId) throws ApiException {
        ApiResponse<List<WebhookResponseModel>> localVarResp = this.getWebhooksWithHttpInfo(productId);
        return localVarResp.getData();
    }

    public ApiResponse<List<WebhookResponseModel>> getWebhooksWithHttpInfo(UUID productId) throws ApiException {
        Call localVarCall = this.getWebhooksValidateBeforeCall(productId, null);
        Type localVarReturnType = new TypeToken<List<WebhookResponseModel>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWebhooksAsync(UUID productId, ApiCallback<List<WebhookResponseModel>> _callback) throws ApiException {
        Call localVarCall = this.getWebhooksValidateBeforeCall(productId, _callback);
        Type localVarReturnType = new TypeToken<List<WebhookResponseModel>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceWebhookCall(Integer webhookId, WebHookRequestModel webHookRequestModel, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WebHookRequestModel localVarPostBody = webHookRequestModel;
        String localVarPath = "/v1/webhooks/{webhookId}".replace("{webhookId}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceWebhookValidateBeforeCall(Integer webhookId, WebHookRequestModel webHookRequestModel, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling replaceWebhook(Async)");
        }
        if (webHookRequestModel == null) {
            throw new ApiException("Missing the required parameter 'webHookRequestModel' when calling replaceWebhook(Async)");
        }
        return this.replaceWebhookCall(webhookId, webHookRequestModel, _callback);
    }

    public WebhookResponseModel replaceWebhook(Integer webhookId, WebHookRequestModel webHookRequestModel) throws ApiException {
        ApiResponse<WebhookResponseModel> localVarResp = this.replaceWebhookWithHttpInfo(webhookId, webHookRequestModel);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookResponseModel> replaceWebhookWithHttpInfo(Integer webhookId, WebHookRequestModel webHookRequestModel) throws ApiException {
        Call localVarCall = this.replaceWebhookValidateBeforeCall(webhookId, webHookRequestModel, null);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceWebhookAsync(Integer webhookId, WebHookRequestModel webHookRequestModel, ApiCallback<WebhookResponseModel> _callback) throws ApiException {
        Call localVarCall = this.replaceWebhookValidateBeforeCall(webhookId, webHookRequestModel, _callback);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateWebhookCall(Integer webhookId, List<JsonPatchOperation> jsonPatchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<JsonPatchOperation> localVarPostBody = jsonPatchOperation;
        String localVarPath = "/v1/webhooks/{webhookId}".replace("{webhookId}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"Basic"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateWebhookValidateBeforeCall(Integer webhookId, List<JsonPatchOperation> jsonPatchOperation, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling updateWebhook(Async)");
        }
        if (jsonPatchOperation == null) {
            throw new ApiException("Missing the required parameter 'jsonPatchOperation' when calling updateWebhook(Async)");
        }
        return this.updateWebhookCall(webhookId, jsonPatchOperation, _callback);
    }

    public WebhookResponseModel updateWebhook(Integer webhookId, List<JsonPatchOperation> jsonPatchOperation) throws ApiException {
        ApiResponse<WebhookResponseModel> localVarResp = this.updateWebhookWithHttpInfo(webhookId, jsonPatchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookResponseModel> updateWebhookWithHttpInfo(Integer webhookId, List<JsonPatchOperation> jsonPatchOperation) throws ApiException {
        Call localVarCall = this.updateWebhookValidateBeforeCall(webhookId, jsonPatchOperation, null);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateWebhookAsync(Integer webhookId, List<JsonPatchOperation> jsonPatchOperation, ApiCallback<WebhookResponseModel> _callback) throws ApiException {
        Call localVarCall = this.updateWebhookValidateBeforeCall(webhookId, jsonPatchOperation, _callback);
        Type localVarReturnType = new TypeToken<WebhookResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

