/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum AccessType {
    READ_ONLY("readOnly"),
    FULL("full"),
    CUSTOM("custom");

    private String value;

    private AccessType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessType fromValue(String value) {
        for (AccessType b : AccessType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        AccessType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<AccessType> {
        public void write(JsonWriter jsonWriter, AccessType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AccessType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AccessType.fromValue(value);
        }
    }
}

