/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum OperationType {
    UNKNOWN("unknown"),
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move"),
    COPY("copy"),
    TEST("test");

    private String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationType fromValue(String value) {
        for (OperationType b : OperationType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        OperationType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<OperationType> {
        public void write(JsonWriter jsonWriter, OperationType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public OperationType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OperationType.fromValue(value);
        }
    }
}

