/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum SettingType {
    BOOLEAN("boolean"),
    STRING("string"),
    INT("int"),
    DOUBLE("double");

    private String value;

    private SettingType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SettingType fromValue(String value) {
        for (SettingType b : SettingType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        SettingType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<SettingType> {
        public void write(JsonWriter jsonWriter, SettingType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public SettingType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return SettingType.fromValue(value);
        }
    }
}

