/*
 * Decompiled with CFR 0.152.
 */
package com.configcat.publicapi.java.client.model;

import com.configcat.publicapi.java.client.JSON;
import com.configcat.publicapi.java.client.model.AbstractOpenApiSchema;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingValueType
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(SettingValueType.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public SettingValueType() {
        super("oneOf", Boolean.FALSE);
    }

    public SettingValueType(Object o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof Boolean) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof String) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof Double) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be Boolean, Double, String");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public Boolean getBoolean() throws ClassCastException {
        return (Boolean)super.getActualInstance();
    }

    public String getString() throws ClassCastException {
        return (String)super.getActualInstance();
    }

    public Double getDouble() throws ClassCastException {
        return (Double)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            if (!jsonElement.getAsJsonPrimitive().isBoolean()) {
                throw new IllegalArgumentException(String.format("Expected json element to be of type Boolean in the JSON string but got `%s`", jsonElement.toString()));
            }
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for Boolean failed with `%s`.", e.getMessage()));
        }
        try {
            if (!jsonElement.getAsJsonPrimitive().isString()) {
                throw new IllegalArgumentException(String.format("Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
            }
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for String failed with `%s`.", e.getMessage()));
        }
        try {
            if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
            }
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for Double failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for SettingValueType with oneOf schemas: Boolean, Double, String. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    public static SettingValueType fromJson(String jsonString) throws IOException {
        return (SettingValueType)JSON.getGson().fromJson(jsonString, SettingValueType.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("Boolean", Boolean.class);
        schemas.put("String", String.class);
        schemas.put("Double", Double.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SettingValueType.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterBoolean = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Boolean.class));
            final TypeAdapter adapterString = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(String.class));
            final TypeAdapter adapterDouble = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Double.class));
            return new TypeAdapter<SettingValueType>(){

                public void write(JsonWriter out, SettingValueType value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof Boolean) {
                        JsonPrimitive primitive = adapterBoolean.toJsonTree((Object)((Boolean)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof String) {
                        JsonPrimitive primitive = adapterString.toJsonTree((Object)((String)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof Double) {
                        JsonPrimitive primitive = adapterDouble.toJsonTree((Object)((Double)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: Boolean, Double, String");
                }

                public SettingValueType read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isBoolean()) {
                            throw new IllegalArgumentException(String.format("Expected json element to be of type Boolean in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterBoolean;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'Boolean'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for Boolean failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'Boolean'", e);
                    }
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isString()) {
                            throw new IllegalArgumentException(String.format("Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterString;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'String'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for String failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'String'", e);
                    }
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                            throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterDouble;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'Double'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for Double failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'Double'", e);
                    }
                    if (match == 1) {
                        SettingValueType ret = new SettingValueType();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for SettingValueType: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }
}

