/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.ClientContext;
import com.contentful.java.cda.Constants;
import com.contentful.java.cda.model.ArrayResource;
import com.contentful.java.cda.model.CDAArray;
import com.contentful.java.cda.model.CDAAsset;
import com.contentful.java.cda.model.CDAEntry;
import com.contentful.java.cda.model.CDALocale;
import com.contentful.java.cda.model.CDAResource;
import com.contentful.java.cda.model.CDASyncedSpace;
import com.contentful.java.cda.model.ResourceWithMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

class ArrayParser<T extends ArrayResource>
implements Callable<T> {
    private final T source;
    private final ClientContext context;

    public ArrayParser(T source, ClientContext context) {
        this.source = source;
        this.context = context;
    }

    @Override
    public T call() throws Exception {
        ArrayList<CDAResource> items;
        HashMap<String, CDAResource> assets = new HashMap<String, CDAResource>();
        HashMap<String, CDAResource> entries = new HashMap<String, CDAResource>();
        boolean sync = this.source instanceof CDASyncedSpace;
        if (sync) {
            items = ((CDASyncedSpace)this.source).getItems();
        } else if (this.source instanceof CDAArray) {
            items = ((CDAArray)this.source).getItems();
            CDAArray.Includes includes = ((CDAArray)this.source).getIncludes();
            if (includes != null) {
                List<CDAAsset> includedAssets = includes.getAssets();
                List<CDAEntry> includedEntries = includes.getEntries();
                if (includedAssets != null) {
                    for (CDAResource cDAResource : includedAssets) {
                        assets.put((String)cDAResource.getSys().get("id"), cDAResource);
                    }
                }
                if (includedEntries != null) {
                    for (CDAResource cDAResource : includedEntries) {
                        entries.put((String)cDAResource.getSys().get("id"), cDAResource);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid input.");
        }
        for (CDAResource item : items) {
            if (sync && item instanceof ResourceWithMap) {
                this.setLocalizedFields((ResourceWithMap)item);
            }
            if (item instanceof CDAAsset) {
                assets.put((String)item.getSys().get("id"), item);
                continue;
            }
            if (!(item instanceof CDAEntry)) continue;
            entries.put((String)item.getSys().get("id"), item);
        }
        for (CDAResource resource : entries.values()) {
            if (!(resource instanceof ResourceWithMap)) continue;
            this.resolveResourceLinks((ResourceWithMap)resource, assets, entries);
        }
        return this.source;
    }

    private void setLocalizedFields(ResourceWithMap res) {
        Map<String, Object> rawFields = res.getRawFields();
        Map<String, Map> localizedFieldsMap = res.getLocalizedFieldsMap();
        for (CDALocale locale : this.context.spaceWrapper.get().getLocales()) {
            HashMap map = new HashMap();
            for (String key : rawFields.keySet()) {
                String code = locale.getCode();
                Map item = (Map)rawFields.get(key);
                Object value = item.get(code);
                if (value != null) {
                    map.put(key, value);
                }
                localizedFieldsMap.put(code, map);
            }
        }
    }

    private void resolveResourceLinks(ResourceWithMap res, HashMap<String, CDAResource> assets, HashMap<String, CDAResource> entries) {
        Map<String, Map> localizedFields = res.getLocalizedFieldsMap();
        for (Map fields : localizedFields.values()) {
            HashSet removeFromFields = new HashSet();
            for (Object k : fields.keySet()) {
                Object value = fields.get(k);
                if (value instanceof Map) {
                    Map sys = (Map)((Map)value).get("sys");
                    if (sys == null || !this.containsLink(sys)) continue;
                    CDAResource match = this.getMatchForField((Map)value, assets, entries);
                    if (match != null) {
                        fields.put(k, match);
                        continue;
                    }
                    if (!this.context.nullifyUnresolved) continue;
                    removeFromFields.add(k);
                    continue;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                ArrayList modifiedList = new ArrayList();
                for (Object item : list) {
                    Map sys;
                    modifiedList.add(item);
                    int pos = modifiedList.size() - 1;
                    if (!(item instanceof Map) || (sys = (Map)((Map)item).get("sys")) == null || !this.containsLink(sys)) continue;
                    CDAResource match = this.getMatchForField((Map)item, assets, entries);
                    if (match != null) {
                        modifiedList.set(pos, match);
                        continue;
                    }
                    if (!this.context.nullifyUnresolved) continue;
                    modifiedList.remove(pos);
                }
                fields.put(k, modifiedList);
            }
            if (removeFromFields.size() <= 0) continue;
            fields.keySet().removeAll(removeFromFields);
        }
    }

    private boolean containsLink(Map map) {
        String type = (String)map.get("type");
        return Constants.CDAResourceType.Link.equals((Object)Constants.CDAResourceType.valueOf(type));
    }

    private CDAResource getMatchForField(Map map, HashMap<String, CDAResource> assets, HashMap<String, CDAResource> entries) {
        String type;
        CDAResource result = null;
        Map sys = (Map)map.get("sys");
        if (sys != null && Constants.CDAResourceType.Link.equals((Object)Constants.CDAResourceType.valueOf(type = (String)sys.get("type")))) {
            Constants.CDAResourceType linkType = Constants.CDAResourceType.valueOf((String)sys.get("linkType"));
            String id = (String)sys.get("id");
            if (Constants.CDAResourceType.Asset.equals((Object)linkType)) {
                result = assets.get(id);
            } else if (Constants.CDAResourceType.Entry.equals((Object)linkType)) {
                result = entries.get(id);
            }
        }
        return result;
    }
}

