/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.contentful.java.cda.SynchronousExecutor;
import java.util.concurrent.Executor;

abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Base();
    }

    abstract Executor callbackExecutor();

    private static class Android
    extends Platform {
        private Android() {
        }

        @Override
        Executor callbackExecutor() {
            return new Executor(){
                private final Handler handler = new Handler(Looper.getMainLooper());

                @Override
                public void execute(Runnable command) {
                    this.handler.post(command);
                }
            };
        }
    }

    private static class Base
    extends Platform {
        private Base() {
        }

        @Override
        Executor callbackExecutor() {
            return new SynchronousExecutor();
        }
    }
}

