/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDALocale;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.ResourceDeserializer;
import com.contentful.java.cda.ResourceUtils;
import com.contentful.java.cda.SynchronizedSpace;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import retrofit2.Response;

final class ResourceFactory {
    static final Gson GSON = ResourceFactory.createGson();

    private ResourceFactory() {
        throw new AssertionError();
    }

    static CDASpace space(Response<CDASpace> response) {
        CDASpace space = (CDASpace)response.body();
        ResourceFactory.setDefaultLocale(space);
        return space;
    }

    static CDAArray array(Response<CDAArray> arrayResponse, CDAClient client) {
        CDAArray array = (CDAArray)arrayResponse.body();
        array.assets = new HashMap();
        array.entries = new HashMap();
        Set<CDAResource> resources = ResourceFactory.collectResources(array);
        ResourceUtils.localizeResources(resources, client.cache.space());
        ResourceUtils.mapResources(resources, array.assets, array.entries);
        ResourceUtils.setRawFields(array);
        ResourceUtils.resolveLinks(array, client);
        return array;
    }

    private static Set<CDAResource> collectResources(CDAArray array) {
        HashSet<CDAResource> resources = new HashSet<CDAResource>(array.items());
        if (array.includes != null) {
            if (array.includes.assets != null) {
                resources.addAll(array.includes.assets);
            }
            if (array.includes.entries != null) {
                resources.addAll(array.includes.entries);
            }
        }
        return resources;
    }

    static SynchronizedSpace sync(Response<SynchronizedSpace> newSpace, SynchronizedSpace oldSpace, CDAClient client) {
        HashMap<String, CDAAsset> assets = new HashMap<String, CDAAsset>();
        HashMap<String, CDAEntry> entries = new HashMap<String, CDAEntry>();
        if (oldSpace != null) {
            ResourceUtils.mapResources(oldSpace.items(), assets, entries);
        }
        SynchronizedSpace result = ResourceUtils.iterate(newSpace, client);
        ResourceUtils.mapResources(result.items(), assets, entries);
        ResourceUtils.mapDeletedResources(result);
        ArrayList items = new ArrayList();
        items.addAll(assets.values());
        items.addAll(entries.values());
        result.items = items;
        result.assets = assets;
        result.entries = entries;
        ResourceUtils.setRawFields(result);
        ResourceUtils.resolveLinks(result, client);
        return result;
    }

    static <T extends CDAResource> T fromResponse(Response<T> response) {
        return (T)((CDAResource)response.body());
    }

    private static void setDefaultLocale(CDASpace space) {
        for (CDALocale locale : space.locales()) {
            if (!locale.isDefaultLocale()) continue;
            space.defaultLocale = locale;
            break;
        }
    }

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(CDAResource.class, (Object)new ResourceDeserializer()).create();
    }
}

