/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk;

import com.contrastsecurity.exceptions.ResourceNotFoundException;
import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.http.FilterForm;
import com.contrastsecurity.http.HttpMethod;
import com.contrastsecurity.http.ServerFilterForm;
import com.contrastsecurity.http.TraceFilterForm;
import com.contrastsecurity.http.TraceFilterKeycode;
import com.contrastsecurity.http.TraceFilterType;
import com.contrastsecurity.http.UrlBuilder;
import com.contrastsecurity.models.AgentType;
import com.contrastsecurity.models.Applications;
import com.contrastsecurity.models.Coverage;
import com.contrastsecurity.models.Libraries;
import com.contrastsecurity.models.Organizations;
import com.contrastsecurity.models.Rules;
import com.contrastsecurity.models.Servers;
import com.contrastsecurity.models.TraceListing;
import com.contrastsecurity.models.Traces;
import com.contrastsecurity.utils.ContrastSDKUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ContrastSDK {
    private String apiKey;
    private String serviceKey;
    private String user;
    private String restApiURL;
    private UrlBuilder urlBuilder;
    private Gson gson;
    private static final int BAD_REQUEST = 400;
    private static final int SERVER_ERROR = 500;
    private static final String DEFAULT_API_URL = "https://app.contrastsecurity.com/Contrast/api";
    private static final String LOCALHOST_API_URL = "http://localhost:19080/Contrast/api";
    private static final String DEFAULT_AGENT_PROFILE = "default";

    public ContrastSDK() {
    }

    public ContrastSDK(String user, String serviceKey, String apiKey, String restApiURL) throws IllegalArgumentException {
        this.user = user;
        this.serviceKey = serviceKey;
        this.apiKey = apiKey;
        this.restApiURL = restApiURL;
        ContrastSDKUtils.validateUrl(this.restApiURL);
        this.urlBuilder = UrlBuilder.getInstance();
        this.gson = new Gson();
    }

    public ContrastSDK(String user, String serviceKey, String apiKey) {
        this.user = user;
        this.serviceKey = serviceKey;
        this.apiKey = apiKey;
        this.restApiURL = DEFAULT_API_URL;
        ContrastSDKUtils.validateUrl(this.restApiURL);
        this.urlBuilder = UrlBuilder.getInstance();
        this.gson = new Gson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organizations getProfileOrganizations() throws IOException, UnauthorizedException {
        Organizations organizations;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getProfileOrganizationsUrl());
            reader = new InputStreamReader(is);
            organizations = (Organizations)this.gson.fromJson((Reader)reader, Organizations.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)is);
        return organizations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organizations getProfileDefaultOrganizations() throws IOException, UnauthorizedException {
        Organizations organizations;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getProfileDefaultOrganizationUrl());
            reader = new InputStreamReader(is);
            organizations = (Organizations)this.gson.fromJson((Reader)reader, Organizations.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)is);
        return organizations;
    }

    public Applications getApplication(String organizationId, String appId) throws IOException, UnauthorizedException {
        return this.getApplication(organizationId, appId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Applications getApplication(String organizationId, String appId, EnumSet<FilterForm.ApplicationExpandValues> expandValues) throws IOException, UnauthorizedException {
        Applications applications;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getApplicationUrl(organizationId, appId, expandValues));
            reader = new InputStreamReader(is);
            applications = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)is);
        return applications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Applications getApplications(String organizationId) throws UnauthorizedException, IOException {
        Applications applications;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getApplicationsUrl(organizationId));
            reader = new InputStreamReader(is);
            applications = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)is);
        return applications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coverage getCoverage(String organizationId, String appId) throws IOException, UnauthorizedException {
        Coverage coverage;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getCoverageUrl(organizationId, appId));
            reader = new InputStreamReader(is);
            coverage = (Coverage)this.gson.fromJson((Reader)reader, Coverage.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return coverage;
    }

    public Libraries getLibraries(String organizationId, String appId) throws IOException, UnauthorizedException {
        return this.getLibraries(organizationId, appId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Libraries getLibraries(String organizationId, String appId, EnumSet<FilterForm.LibrariesExpandValues> expandValues) throws IOException, UnauthorizedException {
        Libraries libraries;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLibrariesUrl(organizationId, appId, expandValues));
            reader = new InputStreamReader(is);
            libraries = (Libraries)this.gson.fromJson((Reader)reader, Libraries.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return libraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servers getServers(String organizationId, ServerFilterForm filterForm) throws IOException, UnauthorizedException {
        Servers servers;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getServersUrl(organizationId, filterForm));
            reader = new InputStreamReader(is);
            servers = (Servers)this.gson.fromJson((Reader)reader, Servers.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servers getServersWithFilter(String organizationId, ServerFilterForm filterForm) throws IOException, UnauthorizedException {
        Servers servers;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getServersFilterUrl(organizationId, filterForm));
            reader = new InputStreamReader(is);
            servers = (Servers)this.gson.fromJson((Reader)reader, Servers.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Traces getTraces(String organizationId, String appId, TraceFilterForm form) throws IOException, UnauthorizedException {
        Traces traces;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTracesByApplicationUrl(organizationId, appId, form));
            reader = new InputStreamReader(is);
            traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return traces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceListing getTraceFilters(String organizationId, String appId) throws IOException, UnauthorizedException {
        TraceListing traceListing;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTraceListingUrl(organizationId, appId, TraceFilterType.VULNTYPE));
            reader = new InputStreamReader(is);
            traceListing = (TraceListing)this.gson.fromJson((Reader)reader, TraceListing.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return traceListing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Traces getTracesWithFilter(String organizationId, String appId, TraceFilterType traceFilterType, TraceFilterKeycode keycode, TraceFilterForm form) throws IOException, UnauthorizedException {
        Traces traces;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTracesWithFilterUrl(organizationId, appId, traceFilterType, keycode, form));
            reader = new InputStreamReader(is);
            traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return traces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Traces getTraceFilterByRule(String organizationId, String appId, List<String> ruleNames) throws IOException, UnauthorizedException {
        Traces traces;
        InputStream is = null;
        InputStreamReader reader = null;
        TraceFilterForm ruleNameForm = new TraceFilterForm();
        ruleNameForm.setVulnTypes(ruleNames);
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTracesByApplicationUrl(organizationId, appId, ruleNameForm));
            reader = new InputStreamReader(is);
            traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return traces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rules getRules(String organizationId) throws IOException, UnauthorizedException {
        Rules rules;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getRules(organizationId));
            reader = new InputStreamReader(is);
            rules = (Rules)this.gson.fromJson((Reader)reader, Rules.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)reader);
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAgent(AgentType type, String organizationId, String profileName) throws IOException, UnauthorizedException {
        byte[] byArray;
        InputStream is = null;
        try {
            is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getAgentUrl(type, organizationId, profileName));
            byArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    public byte[] getAgent(AgentType type, String organizationId) throws IOException, UnauthorizedException {
        return this.getAgent(type, organizationId, DEFAULT_AGENT_PROFILE);
    }

    public static void main(String[] args) throws UnauthorizedException, IOException, ResourceNotFoundException {
        ContrastSDK conn = new ContrastSDK("contrast_admin", "demo", "demo", LOCALHOST_API_URL);
        String orgId = conn.getProfileDefaultOrganizations().getOrganization().getOrgUuid();
        String appId = "";
        Gson gson = new Gson();
        System.out.println(gson.toJson((Object)conn.getProfileOrganizations()));
    }

    public InputStream makeRequest(HttpMethod method, String path) throws IOException, UnauthorizedException {
        String url = this.restApiURL + path;
        HttpURLConnection connection = this.makeConnection(url, method.toString());
        InputStream is = connection.getInputStream();
        int rc = connection.getResponseCode();
        if (rc >= 400 && rc < 500) {
            IOUtils.closeQuietly((InputStream)is);
            throw new UnauthorizedException(rc);
        }
        return is;
    }

    public HttpURLConnection makeConnection(String url, String method) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", ContrastSDKUtils.makeAuthorizationToken(this.user, this.serviceKey));
        connection.setRequestProperty("API-Key", this.apiKey);
        connection.setUseCaches(false);
        return connection;
    }
}

