package com.contrastsecurity.models;

import com.google.gson.annotations.SerializedName;

import java.util.List;

public class VulnerabilityTrend {

    // Inner Class for Trend Step
    public class TrendStep {
        // Inner Inner for status name value pairs
        public class StatusBreakdown {
            public String getName() { return this.name; }
            @SerializedName("name")
            private String name;

            public int getValue() {
                return this.value;
            }
            @SerializedName("value")
            private int value = 0;
        }

        /**
         * The count for the trend step
         *
         * @return the count for the trend step
         */
        public int getCount() {
            return this.count;
        }

        @SerializedName("count")
        private int count = 0;

        /**
         * The timestamp for the trend step
         *
         * @return the timestamp for the trend step
         */
        public long getTimestamp() {
            return this.timestamp;
        }

        @SerializedName("timestamp")
        private long timestamp = 0;

        /**
         * The breakdown for the trend step
         *
         * @return the breakdown for the trend step
         */
        public List<StatusBreakdown> getBreakdown() {
            return this.statusBreakdown;
        }

        @SerializedName("statusBreakdown")
        private List<StatusBreakdown> statusBreakdown;
    }

    /**
     * Return the open vulnerability trends
     *
     * @return the open vulnerability trends
     */
    public List<TrendStep> getOpenTrend() {
        return openSteps;
    }
    @SerializedName("open")
    private List<TrendStep> openSteps;

    /**
     * Return the closed vulnerability trends
     *
     * @return the closed vulnerability trends
     */
    public List<TrendStep> getClosedTrend() {
        return closedSteps;
    }
    @SerializedName("closed")
    private List<TrendStep> closedSteps;
}
