/*
 * Decompiled with CFR 0.152.
 */
package com.cookingfox.util.uid;

import com.cookingfox.util.uid.Uid;
import com.cookingfox.util.uid.UidKeyTranslatorException;
import java.util.LinkedHashMap;
import java.util.Map;

public class UidKeyTranslator<T> {
    protected final Map<Uid, T> dictionary = new LinkedHashMap<Uid, T>();

    public UidKeyTranslator() {
    }

    public UidKeyTranslator(Map<Uid, T> map) throws UidKeyTranslatorException {
        this.addToDictionary(map);
    }

    public void addToDictionary(Map<Uid, T> map) throws UidKeyTranslatorException {
        for (Map.Entry<Uid, T> entry : map.entrySet()) {
            Uid key = entry.getKey();
            if (!Uid.class.isInstance(key)) {
                String type = key == null ? null : key.getClass().getSimpleName();
                throw new UidKeyTranslatorException(String.format("The map can only contain keys that are Uid instances (%s)", type));
            }
            if (!this.dictionary.containsKey(key)) continue;
            throw new UidKeyTranslatorException("The following key is already present in the dictionary: " + key);
        }
        this.dictionary.putAll(map);
    }

    public T fromUid(Uid uid) throws UidKeyTranslatorException {
        T key = this.dictionary.get(uid);
        if (null == key) {
            throw new UidKeyTranslatorException("Provided Uid is not in the dictionary: " + uid);
        }
        return key;
    }

    public Map<T, ?> fromUidMap(Map<Uid, ?> map) throws UidKeyTranslatorException {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<Uid, ?> entry : map.entrySet()) {
            result.put(this.fromUid(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public Uid toUid(T key) throws UidKeyTranslatorException {
        for (Map.Entry<Uid, T> entry : this.dictionary.entrySet()) {
            if (!key.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new UidKeyTranslatorException("Provided key is not in the dictionary: " + key);
    }

    public Map<Uid, ?> toUidMap(Map<T, Object> map) throws UidKeyTranslatorException {
        LinkedHashMap<Uid, Object> result = new LinkedHashMap<Uid, Object>();
        for (Map.Entry<T, Object> entry : map.entrySet()) {
            result.put(this.toUid(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public String toString() {
        return this.dictionary.toString();
    }
}

