/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.BillingDetails;
import com.createsend.models.ExternalSessionOptions;
import com.createsend.models.ExternalSessionResult;
import com.createsend.models.OAuthTokenDetails;
import com.createsend.models.SystemDate;
import com.createsend.models.administrators.Administrator;
import com.createsend.models.administrators.AdministratorResult;
import com.createsend.models.clients.ClientBasics;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.Configuration;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class General
extends CreateSendBase {
    public General(AuthenticationDetails auth) {
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public static String getAuthorizeUrl(int clientID, String redirectUri, String scope, String state) {
        String qs = "client_id=" + String.valueOf(clientID);
        try {
            qs = qs + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8");
            qs = qs + "&scope=" + URLEncoder.encode(scope, "UTF-8");
            if (state != null) {
                qs = qs + "&state=" + URLEncoder.encode(state, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            qs = null;
        }
        return Configuration.Current.getOAuthBaseUri() + "?" + qs;
    }

    public static OAuthTokenDetails exchangeToken(int clientID, String clientSecret, String redirectUri, String code) throws CreateSendException {
        JerseyClientImpl oauthClient = new JerseyClientImpl(null);
        String body = "grant_type=authorization_code";
        try {
            body = body + "&client_id=" + String.valueOf(clientID);
            body = body + "&client_secret=" + URLEncoder.encode(clientSecret, "UTF-8");
            body = body + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8");
            body = body + "&code=" + URLEncoder.encode(code, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            body = null;
        }
        OAuthTokenDetails result = oauthClient.post(Configuration.Current.getOAuthBaseUri(), OAuthTokenDetails.class, (Object)body, MediaType.APPLICATION_FORM_URLENCODED_TYPE, "token");
        return result;
    }

    public ClientBasics[] getClients() throws CreateSendException {
        return this.jerseyClient.get(ClientBasics[].class, "clients.json");
    }

    public BillingDetails getBillingDetails() throws CreateSendException {
        return this.jerseyClient.get(BillingDetails.class, "billingdetails.json");
    }

    public String[] getCountries() throws CreateSendException {
        return this.jerseyClient.get(String[].class, "countries.json");
    }

    public String[] getTimezones() throws CreateSendException {
        return this.jerseyClient.get(String[].class, "timezones.json");
    }

    public Date getSystemDate() throws CreateSendException {
        return this.jerseyClient.get(SystemDate.class, (String[])new String[]{"systemdate.json"}).SystemDate;
    }

    public Administrator[] administrators() throws CreateSendException {
        return this.jerseyClient.get(Administrator[].class, "admins.json");
    }

    public String getPrimaryContact() throws CreateSendException {
        return this.jerseyClient.get(AdministratorResult.class, (String[])new String[]{"primarycontact.json"}).EmailAddress;
    }

    public void setPrimaryContact(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        this.jerseyClient.put((Object)"", (MultivaluedMap<String, String>)queryString, "primarycontact.json");
    }

    public String getExternalSessionUrl(ExternalSessionOptions sessionOptions) throws CreateSendException {
        return this.jerseyClient.put(ExternalSessionResult.class, (Object)sessionOptions, (String[])new String[]{"externalsession.json"}).SessionUrl;
    }
}

