/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.subscribers.EmailToUnsubscribe;
import com.createsend.models.subscribers.HistoryItem;
import com.createsend.models.subscribers.ImportResult;
import com.createsend.models.subscribers.Subscriber;
import com.createsend.models.subscribers.SubscriberToAdd;
import com.createsend.models.subscribers.SubscribersToAdd;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.ErrorDeserialiser;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;

public class Subscribers
extends CreateSendBase {
    private String listID;

    public Subscribers(AuthenticationDetails auth, String listID) {
        this.setListID(listID);
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public void setListID(String listID) {
        this.listID = listID;
    }

    public String getListID() {
        return this.listID;
    }

    public String add(SubscriberToAdd subscriber) throws CreateSendException {
        return this.jerseyClient.post(String.class, (Object)subscriber, "subscribers", this.listID + ".json");
    }

    public ImportResult addMany(SubscribersToAdd subscribers) throws CreateSendException {
        return this.jerseyClient.post(ImportResult.class, (Object)subscribers, new ErrorDeserialiser(), "subscribers", this.listID, "import.json");
    }

    public Subscriber details(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        return this.jerseyClient.get(Subscriber.class, (MultivaluedMap<String, String>)queryString, "subscribers", this.listID + ".json");
    }

    public HistoryItem[] history(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        return this.jerseyClient.get(HistoryItem[].class, (MultivaluedMap<String, String>)queryString, "subscribers", this.listID, "history.json");
    }

    public void unsubscribe(String emailAddress) throws CreateSendException {
        this.jerseyClient.post(String.class, (Object)EmailToUnsubscribe.fromString(emailAddress), "subscribers", this.listID, "unsubscribe.json");
    }

    public void delete(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        this.jerseyClient.delete((MultivaluedMap<String, String>)queryString, "subscribers", this.listID + ".json");
    }

    public void update(String originalEmailAddress, SubscriberToAdd newDetails) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)originalEmailAddress);
        this.jerseyClient.put((Object)newDetails, (MultivaluedMap<String, String>)queryString, "subscribers", this.listID + ".json");
    }
}

