/*
 * Decompiled with CFR 0.152.
 */
package com.createsend.models.transactional.request;

import com.createsend.models.transactional.EmailContent;
import com.createsend.models.transactional.request.Attachment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClassicEmailRequest {
    private String subject;
    private String from;
    private String replyTo;
    private List<String> to = new ArrayList<String>();
    private List<String> cc = new ArrayList<String>();
    private List<String> bcc = new ArrayList<String>();
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private String text;
    private String html;
    private String group;
    private String addRecipientsToList;
    private boolean inlineCss;
    private boolean trackOpens;
    private boolean trackClicks;

    public ClassicEmailRequest(String to) {
        if (to == null || to.length() == 0) {
            throw new IllegalArgumentException("Must supply a TO address");
        }
        this.to.add(to);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setContent(EmailContent content) {
        this.text = content.getText();
        this.html = content.getHtml();
        this.inlineCss = content.isInlineCss();
        this.trackOpens = content.isTrackOpens();
        this.trackClicks = content.isTrackClicks();
    }

    public String getText() {
        return this.text;
    }

    public String getHtml() {
        return this.html;
    }

    public boolean isInlineCss() {
        return this.inlineCss;
    }

    public boolean isTrackClicks() {
        return this.trackClicks;
    }

    public boolean isTrackOpens() {
        return this.trackOpens;
    }

    public void addTo(String recipient) {
        this.to.add(recipient);
    }

    public Iterator<String> getTo() {
        return this.to.iterator();
    }

    public void addCc(String recipient) {
        this.cc.add(recipient);
    }

    public void addBcc(String recipient) {
        this.bcc.add(recipient);
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAddRecipientsToList(String addRecipientsToList) {
        this.addRecipientsToList = addRecipientsToList;
    }

    public String getAddRecipientsToList() {
        return this.addRecipientsToList;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

