/*
 * Decompiled with CFR 0.152.
 */
package com.createsend.util;

import com.createsend.models.ApiErrorResponse;
import com.createsend.models.PagedResult;
import com.createsend.util.ApiKeyAuthenticationDetails;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.Configuration;
import com.createsend.util.ErrorDeserialiser;
import com.createsend.util.JerseyClient;
import com.createsend.util.OAuthAuthenticationDetails;
import com.createsend.util.exceptions.BadRequestException;
import com.createsend.util.exceptions.CreateSendException;
import com.createsend.util.exceptions.CreateSendHttpException;
import com.createsend.util.exceptions.ExpiredOAuthTokenException;
import com.createsend.util.exceptions.NotFoundException;
import com.createsend.util.exceptions.ServerErrorException;
import com.createsend.util.exceptions.UnauthorisedException;
import com.createsend.util.jersey.AuthorisedResourceFactory;
import com.createsend.util.jersey.JsonProvider;
import com.createsend.util.jersey.ResourceFactory;
import com.createsend.util.jersey.UnauthorisedResourceFactory;
import com.createsend.util.jersey.UserAgentFilter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class JerseyClientImpl
implements JerseyClient {
    private static Client client;
    private ErrorDeserialiser<String> defaultDeserialiser = new ErrorDeserialiser<String>(){};
    private ResourceFactory authorisedResourceFactory;
    private AuthenticationDetails authDetails;

    public JerseyClientImpl(AuthenticationDetails auth) {
        this.setAuthenticationDetails(auth);
    }

    @Override
    public AuthenticationDetails getAuthenticationDetails() {
        return this.authDetails;
    }

    @Override
    public void setAuthenticationDetails(AuthenticationDetails authDetails) {
        this.authDetails = authDetails;
        if (authDetails instanceof OAuthAuthenticationDetails) {
            OAuthAuthenticationDetails oauthDetails = (OAuthAuthenticationDetails)authDetails;
            this.authorisedResourceFactory = new AuthorisedResourceFactory(oauthDetails.getAccessToken());
        } else if (authDetails instanceof ApiKeyAuthenticationDetails) {
            ApiKeyAuthenticationDetails apiKeyDetails = (ApiKeyAuthenticationDetails)authDetails;
            this.authorisedResourceFactory = new AuthorisedResourceFactory(apiKeyDetails.getApiKey(), "x");
        } else {
            this.authorisedResourceFactory = new UnauthorisedResourceFactory();
        }
    }

    @Override
    public <T> T get(Class<T> klass, String ... pathElements) throws CreateSendException {
        return this.get(klass, null, this.authorisedResourceFactory, pathElements);
    }

    @Override
    public <T> T get(Class<T> klass, ErrorDeserialiser<?> errorDeserialiser, String ... pathElements) throws CreateSendException {
        return this.get(klass, null, this.authorisedResourceFactory, errorDeserialiser, pathElements);
    }

    @Override
    public <T> T get(Class<T> klass, MultivaluedMap<String, String> queryString, String ... pathElements) throws CreateSendException {
        return this.get(klass, queryString, this.authorisedResourceFactory, pathElements);
    }

    @Override
    public <T> T get(Class<T> klass, MultivaluedMap<String, String> queryString, ResourceFactory resourceFactory, String ... pathElements) throws CreateSendException {
        return this.get(klass, queryString, resourceFactory, this.defaultDeserialiser, pathElements);
    }

    public <T> T get(Class<T> klass, MultivaluedMap<String, String> queryString, ResourceFactory resourceFactory, ErrorDeserialiser<?> errorDeserialiser, String ... pathElements) throws CreateSendException {
        WebResource resource = resourceFactory.getResource(client, pathElements);
        if (queryString != null) {
            resource = resource.queryParams(queryString);
        }
        try {
            return (T)this.fixStringResult(klass, resource.get(klass));
        }
        catch (UniformInterfaceException ue) {
            throw this.handleErrorResponse(ue, errorDeserialiser);
        }
    }

    @Override
    public <T> PagedResult<T> getPagedResult(Integer page, Integer pageSize, String orderField, String orderDirection, MultivaluedMap<String, String> queryString, String ... pathElements) throws CreateSendException {
        WebResource resource = this.authorisedResourceFactory.getResource(client, pathElements);
        if (queryString == null) {
            queryString = new MultivaluedMapImpl();
        }
        this.addPagingParams((MultivaluedMap<String, String>)queryString, page, pageSize, orderField, orderDirection);
        try {
            if (queryString != null) {
                resource = resource.queryParams((MultivaluedMap)queryString);
            }
            return (PagedResult)resource.get(new GenericType((Type)this.getGenericReturnType()));
        }
        catch (UniformInterfaceException ue) {
            throw this.handleErrorResponse(ue, this.defaultDeserialiser);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <T> T post(Class<T> klass, Object entity, String ... pathElements) throws CreateSendException {
        return this.post(null, klass, entity, this.defaultDeserialiser, MediaType.APPLICATION_JSON_TYPE, pathElements);
    }

    @Override
    public <T> T post(Class<T> klass, MultivaluedMap<String, String> queryString, Object entity, String ... pathElements) throws CreateSendException {
        return this.post(null, klass, queryString, entity, this.defaultDeserialiser, MediaType.APPLICATION_JSON_TYPE, pathElements);
    }

    @Override
    public <T> T post(Class<T> klass, Object entity, ErrorDeserialiser<?> errorDeserialiser, String ... pathElements) throws CreateSendException {
        return this.post(null, klass, entity, errorDeserialiser, MediaType.APPLICATION_JSON_TYPE, pathElements);
    }

    @Override
    public <T> T post(String baseUri, Class<T> klass, Object entity, String ... pathElements) throws CreateSendException {
        return this.post(baseUri, klass, entity, this.defaultDeserialiser, MediaType.APPLICATION_JSON_TYPE, pathElements);
    }

    @Override
    public <T> T post(String baseUri, Class<T> klass, Object entity, ErrorDeserialiser<?> errorDeserialiser, String ... pathElements) throws CreateSendException {
        return this.post(baseUri, klass, entity, errorDeserialiser, MediaType.APPLICATION_JSON_TYPE, pathElements);
    }

    @Override
    public <T> T post(Class<T> klass, Object entity, MediaType mediaType, String ... pathElements) throws CreateSendException {
        return this.post(null, klass, entity, this.defaultDeserialiser, mediaType, pathElements);
    }

    @Override
    public <T> T post(String baseUri, Class<T> klass, Object entity, MediaType mediaType, String ... pathElements) throws CreateSendException {
        return this.post(baseUri, klass, entity, this.defaultDeserialiser, mediaType, pathElements);
    }

    @Override
    public <T> T post(String baseUri, Class<T> klass, Object entity, ErrorDeserialiser<?> errorDeserialiser, MediaType mediaType, String ... pathElements) throws CreateSendException {
        return this.post(baseUri, klass, null, entity, errorDeserialiser, mediaType, pathElements);
    }

    private <T> T post(String baseUri, Class<T> klass, MultivaluedMap<String, String> queryString, Object entity, ErrorDeserialiser<?> errorDeserialiser, MediaType mediaType, String ... pathElements) throws CreateSendException {
        WebResource resource = baseUri != null ? this.authorisedResourceFactory.getResource(baseUri, client, pathElements) : this.authorisedResourceFactory.getResource(client, pathElements);
        if (queryString != null) {
            resource = resource.queryParams(queryString);
        }
        try {
            WebResource.Builder builder = resource.type(mediaType);
            return (T)this.fixStringResult(klass, entity == null ? builder.post(klass, (Object)"") : builder.post(klass, entity));
        }
        catch (UniformInterfaceException ue) {
            throw this.handleErrorResponse(ue, errorDeserialiser);
        }
    }

    @Override
    public void put(Object entity, String ... pathElements) throws CreateSendException {
        this.put(entity, null, this.defaultDeserialiser, pathElements);
    }

    @Override
    public <T> T put(Class<T> klass, Object entity, String ... pathElements) throws CreateSendException {
        WebResource resource = this.authorisedResourceFactory.getResource(client, pathElements);
        try {
            return (T)this.fixStringResult(klass, resource.type(MediaType.APPLICATION_JSON_TYPE).put(klass, entity));
        }
        catch (UniformInterfaceException ue) {
            throw this.handleErrorResponse(ue, this.defaultDeserialiser);
        }
    }

    @Override
    public void put(Object entity, MultivaluedMap<String, String> queryString, String ... pathElements) throws CreateSendException {
        this.put(entity, queryString, this.defaultDeserialiser, pathElements);
    }

    @Override
    public void put(Object entity, ErrorDeserialiser<?> errorDeserialiser, String ... pathElements) throws CreateSendException {
        this.put(entity, null, errorDeserialiser, pathElements);
    }

    private void put(Object entity, MultivaluedMap<String, String> queryString, ErrorDeserialiser<?> errorDeserialiser, String ... pathElements) throws CreateSendException {
        WebResource resource = this.authorisedResourceFactory.getResource(client, pathElements);
        if (queryString != null) {
            resource = resource.queryParams(queryString);
        }
        try {
            resource.type(MediaType.APPLICATION_JSON_TYPE).put(entity);
        }
        catch (UniformInterfaceException ue) {
            throw this.handleErrorResponse(ue, errorDeserialiser);
        }
    }

    @Override
    public void delete(String ... pathElements) throws CreateSendException {
        this.delete((MultivaluedMap<String, String>)null, pathElements);
    }

    @Override
    public void delete(MultivaluedMap<String, String> queryString, String ... pathElements) throws CreateSendException {
        WebResource resource = this.authorisedResourceFactory.getResource(client, pathElements);
        if (queryString != null) {
            resource = resource.queryParams(queryString);
        }
        try {
            resource.delete();
        }
        catch (UniformInterfaceException ue) {
            throw this.handleErrorResponse(ue, this.defaultDeserialiser);
        }
    }

    protected void addPagingParams(MultivaluedMap<String, String> queryString, Integer page, Integer pageSize, String orderField, String orderDirection) {
        if (page != null) {
            queryString.add((Object)"page", (Object)page.toString());
        }
        if (pageSize != null) {
            queryString.add((Object)"pagesize", (Object)pageSize.toString());
        }
        if (orderField != null) {
            queryString.add((Object)"orderfield", (Object)orderField);
        }
        if (orderDirection != null) {
            queryString.add((Object)"orderdirection", (Object)orderDirection);
        }
    }

    protected <T> T fixStringResult(Class<T> klass, T result) {
        if (klass == String.class) {
            String strResult = (String)result;
            if (strResult.startsWith("\"")) {
                strResult = strResult.substring(1);
            }
            if (strResult.endsWith("\"")) {
                strResult = strResult.substring(0, strResult.length() - 1);
            }
            return (T)strResult;
        }
        return result;
    }

    private <T> CreateSendException handleErrorResponse(UniformInterfaceException ue, ErrorDeserialiser<T> deserialiser) {
        ClientResponse response = ue.getResponse();
        ApiErrorResponse<T> apiResponse = null;
        ClientResponse.Status responseStatus = response.getClientResponseStatus();
        if (responseStatus == ClientResponse.Status.BAD_REQUEST || responseStatus == ClientResponse.Status.NOT_FOUND || responseStatus == ClientResponse.Status.UNAUTHORIZED || responseStatus == ClientResponse.Status.INTERNAL_SERVER_ERROR) {
            try {
                apiResponse = deserialiser.getResponse(response);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (apiResponse == null) {
            return this.handleUnknownError(responseStatus);
        }
        if (apiResponse.error != null && apiResponse.error.length() > 0) {
            return this.handleOAuthErrorResponse(responseStatus, apiResponse);
        }
        return this.handleAPIErrorResponse(responseStatus, apiResponse);
    }

    private <T> CreateSendException handleUnknownError(ClientResponse.Status responseStatus) {
        return new CreateSendHttpException(responseStatus);
    }

    private <T> CreateSendException handleAPIErrorResponse(ClientResponse.Status responseStatus, ApiErrorResponse<T> apiResponse) {
        switch (responseStatus) {
            case BAD_REQUEST: {
                return new BadRequestException(apiResponse.Code, apiResponse.Message, apiResponse.ResultData);
            }
            case INTERNAL_SERVER_ERROR: {
                return new ServerErrorException(apiResponse.Code, apiResponse.Message);
            }
            case NOT_FOUND: {
                return new NotFoundException(apiResponse.Code, apiResponse.Message);
            }
            case UNAUTHORIZED: {
                if (apiResponse.Code == 121) {
                    return new ExpiredOAuthTokenException(apiResponse.Code, apiResponse.Message);
                }
                return new UnauthorisedException(apiResponse.Code, apiResponse.Message);
            }
        }
        return new CreateSendHttpException(responseStatus);
    }

    private <T> CreateSendException handleOAuthErrorResponse(ClientResponse.Status responseStatus, ApiErrorResponse<T> apiResponse) {
        return new CreateSendHttpException(String.format("The CreateSend OAuth receiver responded with the following error - %s: %s", apiResponse.error, apiResponse.error_description), responseStatus.getStatusCode(), 0, apiResponse.error_description);
    }

    private ParameterizedType getGenericReturnType() {
        return JerseyClientImpl.getGenericReturnType(null, 4);
    }

    public static ParameterizedType getGenericReturnType(Class<?> klass, int stackFrame) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[stackFrame];
        String callingMethodName = element.getMethodName();
        if (klass == null) {
            try {
                klass = Class.forName(element.getClassName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        for (Method method : klass.getMethods()) {
            if (!method.getName().equals(callingMethodName)) continue;
            return (ParameterizedType)method.getGenericReturnType();
        }
        return null;
    }

    static {
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(JsonProvider.class);
        Map properties = cc.getProperties();
        properties.put("com.sun.jersey.client.property.chunkedEncodingSize", 65536);
        properties.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
        client = Client.create((ClientConfig)cc);
        client.setFollowRedirects(Boolean.valueOf(false));
        if (Configuration.Current.isLoggingEnabled()) {
            client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        client.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
        client.addFilter((ClientFilter)new UserAgentFilter());
    }
}

