/*
 * Decompiled with CFR 0.152.
 */
package com.createsend.util.jersey;

import com.createsend.util.jersey.OAuth2BearerTokenFilter;
import com.createsend.util.jersey.ResourceFactory;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;

public class AuthorisedResourceFactory
extends ResourceFactory {
    private HTTPBasicAuthFilter apiKeyFilter;
    private OAuth2BearerTokenFilter oauthTokenFilter;

    public AuthorisedResourceFactory(String accessToken) {
        this.oauthTokenFilter = new OAuth2BearerTokenFilter(accessToken);
    }

    public AuthorisedResourceFactory(String username, String password) {
        this.apiKeyFilter = new HTTPBasicAuthFilter(username, password);
    }

    @Override
    public WebResource getResource(Client client, String ... pathElements) {
        WebResource resource = super.getResource(client, pathElements);
        if (this.apiKeyFilter != null) {
            resource.addFilter((ClientFilter)this.apiKeyFilter);
        }
        if (this.oauthTokenFilter != null) {
            resource.addFilter((ClientFilter)this.oauthTokenFilter);
        }
        return resource;
    }
}

