/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder;

import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.utils.Message;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GQLSchemaBuilderCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GQLSchemaConfig schemaConfig;
    private final Map<Class<?>, String> typeReferences = new HashMap();
    private final Map<Class<?>, GraphQLEnumType> enumTypes = new HashMap();
    private final Map<Class<?>, GraphQLInterfaceType> interfaceTypes = new HashMap();
    private final Map<Class<?>, GraphQLObjectType> objectTypes = new HashMap();
    private final Map<Class<?>, GraphQLInputObjectType> inputEntityTypes = new HashMap();
    private GraphQLOutputType deleteResultOutputObjectType;
    private GraphQLEnumType orderByDirectionEnumType;
    private GraphQLInputObjectType pagingInputObjectType;
    private GraphQLInputObjectType orderByInputObjectType;
    private final Map<String, GraphQLInputObjectType> inputScalarFilterOperators = new HashMap<String, GraphQLInputObjectType>();
    private final Map<Class<?>, GraphQLInputObjectType> inputEnumFilterOperators = new HashMap();
    private GraphQLInputObjectType inputEntityCollectionFilterOperator;
    private GraphQLOutputType pagingOutputObjectType;
    private GraphQLOutputType orderByOutputObjectType;
    private GraphQLCodeRegistry.Builder codeRegistryBuilder;

    public GQLSchemaBuilderCache(GQLSchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    public GraphQLEnumType getEnumType(Class<?> enumClass) {
        GraphQLEnumType enumType = this.enumTypes.get(enumClass);
        if (enumType == null) {
            throw new IllegalArgumentException(Message.format("No enum type defined for enum class [{}]", enumClass));
        }
        return enumType;
    }

    public GraphQLObjectType getEntityType(Class<?> entityClass) {
        GraphQLObjectType objectType = this.objectTypes.get(entityClass);
        if (objectType == null) {
            throw new IllegalArgumentException(Message.format("No entity type defined for entity class [{}]", entityClass));
        }
        return objectType;
    }

    public GraphQLInterfaceType getInterfaceType(Class<?> entityClass) {
        GraphQLInterfaceType interfaceType = this.interfaceTypes.get(entityClass);
        if (interfaceType == null) {
            throw new IllegalArgumentException(Message.format("No interface type defined for entity class [{}]", entityClass));
        }
        return interfaceType;
    }

    public GraphQLScalarType getScalarType(String scalarTypeCode) {
        Optional<GraphQLScalarType> scalarType = this.schemaConfig.getScalarType(scalarTypeCode);
        if (!scalarType.isPresent()) {
            throw new IllegalArgumentException(Message.format("No scalar type defined for scalar type code [{}]", scalarTypeCode));
        }
        return scalarType.get();
    }

    public String getEntityTypeName(Class<?> entityClass) {
        String typeName = this.typeReferences.get(entityClass);
        if (typeName == null) {
            throw new IllegalArgumentException(Message.format("No entity type name defined for entity class [{}]", entityClass));
        }
        return typeName;
    }

    public GraphQLInputObjectType getInputEntityType(Class<?> entityClass) {
        GraphQLInputObjectType objectType = this.getInputEntityTypes().get(entityClass);
        if (objectType == null) {
            throw new IllegalArgumentException(Message.format("No input entity type defined for entity class [{}]", entityClass));
        }
        return objectType;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Map<Class<?>, String> getTypeReferences() {
        return this.typeReferences;
    }

    public Map<Class<?>, GraphQLEnumType> getEnumTypes() {
        return this.enumTypes;
    }

    public Map<Class<?>, GraphQLInterfaceType> getInterfaceTypes() {
        return this.interfaceTypes;
    }

    public Map<Class<?>, GraphQLObjectType> getObjectTypes() {
        return this.objectTypes;
    }

    public Map<Class<?>, GraphQLInputObjectType> getInputEntityTypes() {
        return this.inputEntityTypes;
    }

    public GraphQLEnumType getOrderByDirectionEnumType() {
        return this.orderByDirectionEnumType;
    }

    public void setOrderByDirectionEnumType(GraphQLEnumType orderByDirectionEnumType) {
        this.orderByDirectionEnumType = orderByDirectionEnumType;
    }

    public GraphQLInputObjectType getPagingInputObjectType() {
        return this.pagingInputObjectType;
    }

    public void setPagingInputObjectType(GraphQLInputObjectType pagingInputObjectType) {
        this.pagingInputObjectType = pagingInputObjectType;
    }

    public GraphQLInputObjectType getOrderByInputObjectType() {
        return this.orderByInputObjectType;
    }

    public void setOrderByInputObjectType(GraphQLInputObjectType orderByInputObjectType) {
        this.orderByInputObjectType = orderByInputObjectType;
    }

    public GraphQLOutputType getPagingOutputObjectType() {
        return this.pagingOutputObjectType;
    }

    public void setPagingOutputObjectType(GraphQLOutputType pagingOutputObjectType) {
        this.pagingOutputObjectType = pagingOutputObjectType;
    }

    public GraphQLOutputType getOrderByOutputObjectType() {
        return this.orderByOutputObjectType;
    }

    public Map<String, GraphQLInputObjectType> getInputScalarFilterOperators() {
        return this.inputScalarFilterOperators;
    }

    public Map<Class<?>, GraphQLInputObjectType> getInputEnumFilterOperators() {
        return this.inputEnumFilterOperators;
    }

    public GraphQLInputObjectType getInputEntityCollectionFilterOperator() {
        return this.inputEntityCollectionFilterOperator;
    }

    public void setInputEntityCollectionFilterOperator(GraphQLInputObjectType inputEntityCollectionFilterOperator) {
        this.inputEntityCollectionFilterOperator = inputEntityCollectionFilterOperator;
    }

    public GraphQLCodeRegistry.Builder getCodeRegistryBuilder() {
        return this.codeRegistryBuilder;
    }

    public void setCodeRegistryBuilder(GraphQLCodeRegistry.Builder codeRegistryBuilder) {
        this.codeRegistryBuilder = codeRegistryBuilder;
    }

    public GraphQLOutputType getDeleteResultOutputObjectType() {
        return this.deleteResultOutputObjectType;
    }

    public void setDeleteResultOutputObjectType(GraphQLOutputType deleteResultOutputObjectType) {
        this.deleteResultOutputObjectType = deleteResultOutputObjectType;
    }

    public void setOrderByOutputObjectType(GraphQLOutputType orderByOutputObjectType) {
        this.orderByOutputObjectType = orderByOutputObjectType;
    }

    public GQLSchemaConfig getConfig() {
        return this.schemaConfig;
    }
}

