/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLAbstractTypesBuilder;
import com.daikit.graphql.enums.GQLFilterOperatorEnum;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class GQLQueryFilterOperatorsInputTypeBuilder
extends GQLAbstractTypesBuilder {
    public GQLQueryFilterOperatorsInputTypeBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildFilterOperatorsInputTypes(GQLInternalMetaModel metaModel) {
        this.logger.debug("Build filter operators types");
        this.getCache().getInputScalarFilterOperators().putAll(this.buildScalarFilterOperatorsInputObjectTypes());
        metaModel.getEnums().forEach(enumMeta -> this.getCache().getInputEnumFilterOperators().put(enumMeta.getEnumClass(), this.buildEnumFilterOperatorsInputObjectType((GQLEnumMetaData)enumMeta)));
        this.getCache().setInputEntityCollectionFilterOperator(this.buildEntityCollectionOperatorsInputObjectType());
    }

    private GraphQLInputObjectType buildEntityCollectionOperatorsInputObjectType() {
        GraphQLEnumType collectionOperatorEnumType = this.buildOperatorEnumType("collection", GQLFilterOperatorEnum.__COLLECTION_OPERATORS);
        return this.buildFilterOperator(collectionOperatorEnumType, "EntityCollection", (GraphQLType)new GraphQLList((GraphQLType)this.getConfig().getScalarType(GQLScalarTypeEnum.ID.toString()).get()));
    }

    private Map<String, GraphQLInputObjectType> buildScalarFilterOperatorsInputObjectTypes() {
        HashMap<String, GraphQLInputObjectType> filterOperators = new HashMap<String, GraphQLInputObjectType>();
        GraphQLEnumType numberOperatorEnumType = this.buildOperatorEnumType("numbers", GQLFilterOperatorEnum.__NUMBER_OPERATORS);
        GraphQLEnumType booleanOperatorEnumType = this.buildOperatorEnumType("booleans", GQLFilterOperatorEnum.__BOOLEAN_OPERATORS);
        GraphQLEnumType dateOperatorEnumType = this.buildOperatorEnumType("dates", GQLFilterOperatorEnum.__DATE_OPERATORS);
        GraphQLEnumType stringOperatorEnumType = this.buildOperatorEnumType("strings", GQLFilterOperatorEnum.__STRING_OPERATORS);
        GraphQLEnumType idOperatorEnumType = this.buildOperatorEnumType("entities", GQLFilterOperatorEnum.__ID_OPERATORS);
        HashMap<GQLScalarTypeEnum, GraphQLEnumType> scalarOperators = new HashMap<GQLScalarTypeEnum, GraphQLEnumType>();
        scalarOperators.put(GQLScalarTypeEnum.BIG_DECIMAL, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.BIG_INTEGER, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.LONG, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.SHORT, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.FLOAT, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.INT, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.ID, idOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.BOOLEAN, booleanOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.DATE, dateOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.LOCAL_DATE, dateOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.LOCAL_DATE_TIME, dateOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.INSTANT, dateOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.CHAR, stringOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.STRING, stringOperatorEnumType);
        scalarOperators.entrySet().forEach(entry -> filterOperators.put(((GQLScalarTypeEnum)((Object)((Object)entry.getKey()))).toString(), this.buildFilterOperator((GraphQLEnumType)entry.getValue(), StringUtils.remove((String)WordUtils.capitalizeFully((String)((GQLScalarTypeEnum)((Object)((Object)entry.getKey()))).name(), (char[])new char[]{'_'}), (String)"_"), (GraphQLType)this.getConfig().getScalarType(((GQLScalarTypeEnum)((Object)((Object)entry.getKey()))).toString()).get())));
        return filterOperators;
    }

    private GraphQLEnumType buildOperatorEnumType(String typeName, Collection<GQLFilterOperatorEnum> operators) {
        GraphQLEnumType.Builder operatorEnumTypeBuilder = GraphQLEnumType.newEnum();
        operatorEnumTypeBuilder.name("FilterOperatorEnum" + this.removeEnumSuffix(StringUtils.capitalize((String)typeName)));
        operatorEnumTypeBuilder.description("Filter operators for " + typeName + ".");
        operators.forEach(operator -> operatorEnumTypeBuilder.value(operator.getCode(), (Object)operator, operator.getDescription()));
        return operatorEnumTypeBuilder.build();
    }

    private GraphQLInputObjectType buildEnumFilterOperatorsInputObjectType(GQLEnumMetaData enumMetaData) {
        GraphQLEnumType enumOperatorEnumType = this.buildOperatorEnumType(enumMetaData.getName(), GQLFilterOperatorEnum.__ENUM_OPERATORS);
        return this.buildFilterOperator(enumOperatorEnumType, enumMetaData.getName(), (GraphQLType)this.getCache().getEnumType(enumMetaData.getEnumClass()));
    }

    private String removeEnumSuffix(String name) {
        return name.endsWith("Enum") ? name.substring(0, name.length() - 4) : name;
    }

    private GraphQLInputObjectType buildFilterOperator(GraphQLEnumType operatorType, String typeName, GraphQLType valueType) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name(this.getConfig().getQueryGetListFilterAttributeOperatorTypeNamePrefix() + typeName);
        builder.description("Filter field for value type [" + valueType.getName() + "]");
        GraphQLInputObjectField.Builder operatorFieldBuilder = GraphQLInputObjectField.newInputObjectField();
        operatorFieldBuilder.name(this.getConfig().getQueryGetListFilterAttributeOperatorName());
        operatorFieldBuilder.description("Filter operator.");
        operatorFieldBuilder.type((GraphQLInputType)new GraphQLNonNull((GraphQLType)operatorType));
        builder.field(operatorFieldBuilder.build());
        if (valueType != null) {
            GraphQLInputObjectField.Builder valueFieldBuilder = GraphQLInputObjectField.newInputObjectField();
            valueFieldBuilder.name(this.getConfig().getQueryGetListFilterAttributeValueName());
            valueFieldBuilder.description("Filter value.");
            valueFieldBuilder.type((GraphQLInputType)new GraphQLNonNull(valueType));
            builder.field(valueFieldBuilder.build());
        }
        return builder.build();
    }
}

