/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.config;

import com.daikit.graphql.config.GQLJavaScalars;
import com.daikit.graphql.enums.GQLOrderByDirectionEnum;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GQLSchemaConfig {
    private String queryTypeName = "QueryType";
    private String mutationTypeName = "MutationType";
    private String inputTypeNameSuffix = "InputType";
    private String outputTypeNameSuffix = "OutputType";
    private String queryGetListOutputTypeNameSuffix = "LoadResult";
    private String outputDeleteResultTypeNamePrefix = "DeleteResult";
    private String queryGetListPrefix = "getAll";
    private String queryGetByIdPrefix = "get";
    private String mutationSavePrefix = "save";
    private String mutationDeletePrefix = "delete";
    private String attributeIdSuffix = "Id";
    private String attributePluralSuffix = "s";
    private String attributeIdPluralSuffix = this.attributeIdSuffix + this.attributePluralSuffix;
    private String mutationAttributeInputDataName = "data";
    private String queryGetListAttributeOutputDataName = "data";
    private GQLOrderByDirectionEnum queryGetListFilterAttributeOrderByDirectionDefaultValue = GQLOrderByDirectionEnum.ASC;
    private String mutationDeleteResultAttributeId = "id";
    private String mutationDeleteResultAttributeTypename = "typename";
    private String queryGetListFilterAttributeName = "filter";
    private String queryGetListFilterAttributeOperatorTypeNamePrefix = "FilterOperator";
    private String queryGetListFilterAttributeOperatorName = "operator";
    private String queryGetListFilterAttributeValueName = "value";
    private String queryGetListFilterAttributeOrderByName = "orderBy";
    private String queryGetListFilterAttributeOrderByFieldName = "field";
    private String queryGetListFilterAttributeOrderByDirectionName = "direction";
    private String queryGetListPagingAttributeName = "paging";
    private String queryGetListPagingAttributeTotalLengthName = "totalLength";
    private String queryGetListPagingAttributeOffsetName = "offset";
    private String queryGetListPagingAttributeLimitName = "limit";
    private int queryGetListPagingAttributeLimitDefaultValue = 25;
    private String queryGetListFilterEntityTypeNameSuffix = "Filter";
    private String concreteEmbeddedExtendingTypeNamePrefix = "type";
    private String attributeIdName = "id";
    private final Map<String, GraphQLScalarType> scalars = new HashMap<String, GraphQLScalarType>();
    private final Map<Class<?>, String> scalarTypeMappings = new HashMap();

    public GQLSchemaConfig() {
        this.scalars.put(GQLScalarTypeEnum.INT.toString(), Scalars.GraphQLInt);
        this.scalars.put(GQLScalarTypeEnum.LONG.toString(), Scalars.GraphQLLong);
        this.scalars.put(GQLScalarTypeEnum.FLOAT.toString(), Scalars.GraphQLFloat);
        this.scalars.put(GQLScalarTypeEnum.STRING.toString(), Scalars.GraphQLString);
        this.scalars.put(GQLScalarTypeEnum.BOOLEAN.toString(), Scalars.GraphQLBoolean);
        this.scalars.put(GQLScalarTypeEnum.ID.toString(), Scalars.GraphQLID);
        this.scalars.put(GQLScalarTypeEnum.BIG_INTEGER.toString(), Scalars.GraphQLBigInteger);
        this.scalars.put(GQLScalarTypeEnum.BIG_DECIMAL.toString(), Scalars.GraphQLBigDecimal);
        this.scalars.put(GQLScalarTypeEnum.BYTE.toString(), Scalars.GraphQLByte);
        this.scalars.put(GQLScalarTypeEnum.SHORT.toString(), Scalars.GraphQLShort);
        this.scalars.put(GQLScalarTypeEnum.CHAR.toString(), Scalars.GraphQLChar);
        this.scalars.put(GQLScalarTypeEnum.DATE.toString(), GQLJavaScalars.GraphQLDate);
        this.scalars.put(GQLScalarTypeEnum.FILE.toString(), GQLJavaScalars.GraphQLFile);
        this.scalars.put(GQLScalarTypeEnum.LOCAL_DATE.toString(), GQLJavaScalars.GraphQLLocalDate);
        this.scalars.put(GQLScalarTypeEnum.LOCAL_DATE_TIME.toString(), GQLJavaScalars.GraphQLLocalDateTime);
        this.scalars.put(GQLScalarTypeEnum.INSTANT.toString(), GQLJavaScalars.GraphQLInstant);
        this.scalarTypeMappings.put(IdType.class, GQLScalarTypeEnum.ID.toString());
        this.scalarTypeMappings.put(Integer.TYPE, GQLScalarTypeEnum.INT.toString());
        this.scalarTypeMappings.put(Integer.class, GQLScalarTypeEnum.INT.toString());
        this.scalarTypeMappings.put(Long.TYPE, GQLScalarTypeEnum.LONG.toString());
        this.scalarTypeMappings.put(Long.class, GQLScalarTypeEnum.LONG.toString());
        this.scalarTypeMappings.put(Double.TYPE, GQLScalarTypeEnum.FLOAT.toString());
        this.scalarTypeMappings.put(Double.class, GQLScalarTypeEnum.FLOAT.toString());
        this.scalarTypeMappings.put(Float.TYPE, GQLScalarTypeEnum.FLOAT.toString());
        this.scalarTypeMappings.put(Float.class, GQLScalarTypeEnum.FLOAT.toString());
        this.scalarTypeMappings.put(String.class, GQLScalarTypeEnum.STRING.toString());
        this.scalarTypeMappings.put(Boolean.TYPE, GQLScalarTypeEnum.BOOLEAN.toString());
        this.scalarTypeMappings.put(Boolean.class, GQLScalarTypeEnum.BOOLEAN.toString());
        this.scalarTypeMappings.put(BigInteger.class, GQLScalarTypeEnum.BIG_INTEGER.toString());
        this.scalarTypeMappings.put(BigDecimal.class, GQLScalarTypeEnum.BIG_DECIMAL.toString());
        this.scalarTypeMappings.put(Byte.TYPE, GQLScalarTypeEnum.BYTE.toString());
        this.scalarTypeMappings.put(Byte.class, GQLScalarTypeEnum.BYTE.toString());
        this.scalarTypeMappings.put(Short.TYPE, GQLScalarTypeEnum.SHORT.toString());
        this.scalarTypeMappings.put(Short.class, GQLScalarTypeEnum.SHORT.toString());
        this.scalarTypeMappings.put(Character.TYPE, GQLScalarTypeEnum.CHAR.toString());
        this.scalarTypeMappings.put(Character.class, GQLScalarTypeEnum.CHAR.toString());
        this.scalarTypeMappings.put(Date.class, GQLScalarTypeEnum.DATE.toString());
        this.scalarTypeMappings.put(File.class, GQLScalarTypeEnum.FILE.toString());
        this.scalarTypeMappings.put(LocalDate.class, GQLScalarTypeEnum.LOCAL_DATE.toString());
        this.scalarTypeMappings.put(LocalDateTime.class, GQLScalarTypeEnum.LOCAL_DATE_TIME.toString());
        this.scalarTypeMappings.put(Instant.class, GQLScalarTypeEnum.INSTANT.toString());
    }

    public String removePropertyIdSuffix(String property) {
        String ret = property.endsWith(this.getAttributeIdPluralSuffix()) ? StringUtils.removeEnd((String)property, (String)this.getAttributeIdPluralSuffix()) + this.getAttributePluralSuffix() : StringUtils.removeEnd((String)property, (String)this.getAttributeIdSuffix());
        return ret;
    }

    public Set<Class<?>> getScalarTypeClasses() {
        return this.scalarTypeMappings.keySet().stream().collect(Collectors.toSet());
    }

    public Optional<String> getScalarTypeCodeFromClass(Class<?> scalarClass) {
        return this.scalarTypeMappings.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(scalarClass)).map(Map.Entry::getValue).findFirst();
    }

    public boolean isScalarType(Class<?> clazz) {
        return this.scalarTypeMappings.keySet().stream().filter(key -> key.isAssignableFrom(clazz)).findFirst().isPresent();
    }

    public Optional<GraphQLScalarType> getScalarType(String scalarTypeCode) {
        return Optional.ofNullable(this.scalars.get(scalarTypeCode));
    }

    public Optional<GraphQLScalarType> getScalarTypeFromClass(Class<?> scalarClass) {
        Optional<String> scalarTypeCode = this.getScalarTypeCodeFromClass(scalarClass);
        return scalarTypeCode.isPresent() ? this.getScalarType(scalarTypeCode.get()) : Optional.empty();
    }

    public String getQueryTypeName() {
        return this.queryTypeName;
    }

    public void setQueryTypeName(String queryTypeName) {
        this.queryTypeName = queryTypeName;
    }

    public String getMutationTypeName() {
        return this.mutationTypeName;
    }

    public void setMutationTypeName(String mutationTypeName) {
        this.mutationTypeName = mutationTypeName;
    }

    public String getInputTypeNameSuffix() {
        return this.inputTypeNameSuffix;
    }

    public void setInputTypeNameSuffix(String inputTypeNameSuffix) {
        this.inputTypeNameSuffix = inputTypeNameSuffix;
    }

    public String getOutputTypeNameSuffix() {
        return this.outputTypeNameSuffix;
    }

    public void setOutputTypeNameSuffix(String outputTypeNameSuffix) {
        this.outputTypeNameSuffix = outputTypeNameSuffix;
    }

    public String getQueryGetListOutputTypeNameSuffix() {
        return this.queryGetListOutputTypeNameSuffix;
    }

    public void setQueryGetListOutputTypeNameSuffix(String queryGetListOutputTypeNameSuffix) {
        this.queryGetListOutputTypeNameSuffix = queryGetListOutputTypeNameSuffix;
    }

    public String getOutputDeleteResultTypeNamePrefix() {
        return this.outputDeleteResultTypeNamePrefix;
    }

    public void setOutputDeleteResultTypeNamePrefix(String outputDeleteResultTypeNamePrefix) {
        this.outputDeleteResultTypeNamePrefix = outputDeleteResultTypeNamePrefix;
    }

    public String getQueryGetListPrefix() {
        return this.queryGetListPrefix;
    }

    public void setQueryGetListPrefix(String queryGetListPrefix) {
        this.queryGetListPrefix = queryGetListPrefix;
    }

    public String getQueryGetByIdPrefix() {
        return this.queryGetByIdPrefix;
    }

    public void setQueryGetByIdPrefix(String queryGetByIdPrefix) {
        this.queryGetByIdPrefix = queryGetByIdPrefix;
    }

    public String getMutationSavePrefix() {
        return this.mutationSavePrefix;
    }

    public void setMutationSavePrefix(String mutationSavePrefix) {
        this.mutationSavePrefix = mutationSavePrefix;
    }

    public String getMutationDeletePrefix() {
        return this.mutationDeletePrefix;
    }

    public void setMutationDeletePrefix(String mutationDeletePrefix) {
        this.mutationDeletePrefix = mutationDeletePrefix;
    }

    public String getAttributeIdSuffix() {
        return this.attributeIdSuffix;
    }

    public void setAttributeIdSuffix(String attributeIdSuffix) {
        this.attributeIdSuffix = attributeIdSuffix;
    }

    public String getAttributePluralSuffix() {
        return this.attributePluralSuffix;
    }

    public void setAttributePluralSuffix(String attributePluralSuffix) {
        this.attributePluralSuffix = attributePluralSuffix;
    }

    public String getAttributeIdPluralSuffix() {
        return this.attributeIdPluralSuffix;
    }

    public void setAttributeIdPluralSuffix(String attributeIdPluralSuffix) {
        this.attributeIdPluralSuffix = attributeIdPluralSuffix;
    }

    public String getMutationAttributeInputDataName() {
        return this.mutationAttributeInputDataName;
    }

    public void setMutationAttributeInputDataName(String mutationAttributeInputDataName) {
        this.mutationAttributeInputDataName = mutationAttributeInputDataName;
    }

    public String getQueryGetListAttributeOutputDataName() {
        return this.queryGetListAttributeOutputDataName;
    }

    public void setQueryGetListAttributeOutputDataName(String queryGetListAttributeOutputDataName) {
        this.queryGetListAttributeOutputDataName = queryGetListAttributeOutputDataName;
    }

    public GQLOrderByDirectionEnum getQueryGetListFilterAttributeOrderByDirectionDefaultValue() {
        return this.queryGetListFilterAttributeOrderByDirectionDefaultValue;
    }

    public void setQueryGetListFilterAttributeOrderByDirectionDefaultValue(GQLOrderByDirectionEnum queryGetListFilterAttributeOrderByDirectionDefaultValue) {
        this.queryGetListFilterAttributeOrderByDirectionDefaultValue = queryGetListFilterAttributeOrderByDirectionDefaultValue;
    }

    public String getMutationDeleteResultAttributeId() {
        return this.mutationDeleteResultAttributeId;
    }

    public void setMutationDeleteResultAttributeId(String mutationDeleteResultAttributeId) {
        this.mutationDeleteResultAttributeId = mutationDeleteResultAttributeId;
    }

    public String getMutationDeleteResultAttributeTypename() {
        return this.mutationDeleteResultAttributeTypename;
    }

    public void setMutationDeleteResultAttributeTypename(String mutationDeleteResultAttributeTypename) {
        this.mutationDeleteResultAttributeTypename = mutationDeleteResultAttributeTypename;
    }

    public String getQueryGetListFilterAttributeName() {
        return this.queryGetListFilterAttributeName;
    }

    public void setQueryGetListFilterAttributeName(String queryGetListFilterAttributeName) {
        this.queryGetListFilterAttributeName = queryGetListFilterAttributeName;
    }

    public String getQueryGetListFilterAttributeOperatorTypeNamePrefix() {
        return this.queryGetListFilterAttributeOperatorTypeNamePrefix;
    }

    public void setQueryGetListFilterAttributeOperatorTypeNamePrefix(String queryGetListFilterAttributeOperatorTypeNamePrefix) {
        this.queryGetListFilterAttributeOperatorTypeNamePrefix = queryGetListFilterAttributeOperatorTypeNamePrefix;
    }

    public String getQueryGetListFilterAttributeOperatorName() {
        return this.queryGetListFilterAttributeOperatorName;
    }

    public void setQueryGetListFilterAttributeOperatorName(String queryGetListFilterAttributeOperatorName) {
        this.queryGetListFilterAttributeOperatorName = queryGetListFilterAttributeOperatorName;
    }

    public String getQueryGetListFilterAttributeValueName() {
        return this.queryGetListFilterAttributeValueName;
    }

    public void setQueryGetListFilterAttributeValueName(String queryGetListFilterAttributeValueName) {
        this.queryGetListFilterAttributeValueName = queryGetListFilterAttributeValueName;
    }

    public String getQueryGetListFilterAttributeOrderByName() {
        return this.queryGetListFilterAttributeOrderByName;
    }

    public void setQueryGetListFilterAttributeOrderByName(String queryGetListFilterAttributeOrderByName) {
        this.queryGetListFilterAttributeOrderByName = queryGetListFilterAttributeOrderByName;
    }

    public String getQueryGetListFilterAttributeOrderByFieldName() {
        return this.queryGetListFilterAttributeOrderByFieldName;
    }

    public void setQueryGetListFilterAttributeOrderByFieldName(String queryGetListFilterAttributeOrderByFieldName) {
        this.queryGetListFilterAttributeOrderByFieldName = queryGetListFilterAttributeOrderByFieldName;
    }

    public String getQueryGetListFilterAttributeOrderByDirectionName() {
        return this.queryGetListFilterAttributeOrderByDirectionName;
    }

    public void setQueryGetListFilterAttributeOrderByDirectionName(String queryGetListFilterAttributeOrderByDirectionName) {
        this.queryGetListFilterAttributeOrderByDirectionName = queryGetListFilterAttributeOrderByDirectionName;
    }

    public String getQueryGetListPagingAttributeName() {
        return this.queryGetListPagingAttributeName;
    }

    public void setQueryGetListPagingAttributeName(String queryGetListPagingAttributeName) {
        this.queryGetListPagingAttributeName = queryGetListPagingAttributeName;
    }

    public String getQueryGetListPagingAttributeTotalLengthName() {
        return this.queryGetListPagingAttributeTotalLengthName;
    }

    public void setQueryGetListPagingAttributeTotalLengthName(String queryGetListPagingAttributeTotalLengthName) {
        this.queryGetListPagingAttributeTotalLengthName = queryGetListPagingAttributeTotalLengthName;
    }

    public String getQueryGetListPagingAttributeOffsetName() {
        return this.queryGetListPagingAttributeOffsetName;
    }

    public void setQueryGetListPagingAttributeOffsetName(String queryGetListPagingAttributeOffsetName) {
        this.queryGetListPagingAttributeOffsetName = queryGetListPagingAttributeOffsetName;
    }

    public String getQueryGetListPagingAttributeLimitName() {
        return this.queryGetListPagingAttributeLimitName;
    }

    public void setQueryGetListPagingAttributeLimitName(String queryGetListPagingAttributeLimitName) {
        this.queryGetListPagingAttributeLimitName = queryGetListPagingAttributeLimitName;
    }

    public int getQueryGetListPagingAttributeLimitDefaultValue() {
        return this.queryGetListPagingAttributeLimitDefaultValue;
    }

    public void setQueryGetListPagingAttributeLimitDefaultValue(int queryGetListPagingAttributeLimitDefaultValue) {
        this.queryGetListPagingAttributeLimitDefaultValue = queryGetListPagingAttributeLimitDefaultValue;
    }

    public String getQueryGetListFilterEntityTypeNameSuffix() {
        return this.queryGetListFilterEntityTypeNameSuffix;
    }

    public void setQueryGetListFilterEntityTypeNameSuffix(String queryGetListFilterEntityTypeNameSuffix) {
        this.queryGetListFilterEntityTypeNameSuffix = queryGetListFilterEntityTypeNameSuffix;
    }

    public String getConcreteEmbeddedExtendingTypeNamePrefix() {
        return this.concreteEmbeddedExtendingTypeNamePrefix;
    }

    public void setConcreteEmbeddedExtendingTypeNamePrefix(String concreteEmbeddedExtendingTypeNamePrefix) {
        this.concreteEmbeddedExtendingTypeNamePrefix = concreteEmbeddedExtendingTypeNamePrefix;
    }

    public String getAttributeIdName() {
        return this.attributeIdName;
    }

    public void setAttributeIdName(String attributeIdName) {
        this.attributeIdName = attributeIdName;
    }

    public static final class IdType {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

