/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.meta.GQLInternalMetaModel;
import com.daikit.graphql.utils.Message;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetcher;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class GQLAbstractDataFetcher<FETCHED_DATA_TYPE>
implements DataFetcher<FETCHED_DATA_TYPE> {
    private GQLInternalMetaModel metaModel;
    private GQLSchemaConfig schemaConfig;

    protected Collection<String> getRequestProvidedVariableNames() {
        return Collections.emptyList();
    }

    protected Class<?> getEntityClassByEntityName(String entityName) {
        return this.metaModel.getEntityClassByEntityName(entityName);
    }

    protected String getEntityName(String prefix, String queryName) {
        if (!queryName.startsWith(prefix)) {
            throw new IllegalArgumentException(Message.format("Query name [{}] should start with [{}] prefix.", queryName, prefix));
        }
        return queryName.substring(prefix.length());
    }

    protected Map<String, Object> getArgumentsForContext(Map<String, Object> arguments, String argumentContext) {
        return arguments.containsKey(argumentContext) ? (Map)arguments.get(argumentContext) : Collections.emptyMap();
    }

    protected List<Map<String, Object>> getArgumentsForContextAsList(Map<String, Object> arguments, String argumentContext) {
        return arguments.containsKey(argumentContext) ? (List)arguments.get(argumentContext) : Collections.emptyList();
    }

    protected <T> T mapValue(ObjectField field, Map<String, Object> arguments) {
        return (T)this.mapValue(field.getValue(), field.getName(), arguments);
    }

    protected <T> T mapValue(Argument argument, Map<String, Object> arguments) {
        return (T)this.mapValue(argument.getValue(), argument.getName(), arguments);
    }

    protected Map<String, Object> convertObjectValue(ObjectValue objectValue, Map<String, Object> arguments) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ObjectField objectField : objectValue.getObjectFields()) {
            if (objectField.getValue() instanceof ObjectValue) {
                map.put(objectField.getName(), this.convertObjectValue((ObjectValue)objectField.getValue(), this.getArgumentsForContext(arguments, objectField.getName())));
                continue;
            }
            Object value = this.mapValue(objectField, arguments);
            if (value == null && (!(objectField.getValue() instanceof VariableReference) || !arguments.containsKey(objectField.getName())) && (objectField.getValue() instanceof VariableReference || this.getRequestProvidedVariableNames().contains(objectField.getName()))) continue;
            map.put(objectField.getName(), value);
        }
        Set propNames = map.keySet().stream().collect(Collectors.toSet());
        for (String propName : propNames) {
            String propNamePlural;
            Optional<IGQLDynamicAttributeSetter> dynamicAttributeSetter;
            if (!propName.endsWith(this.getConfig().getAttributeIdPluralSuffix()) || (dynamicAttributeSetter = this.getMetaModel().getDynamicAttributeSetters().stream().filter(dynamicAttribute -> dynamicAttribute.getEntityType().isAssignableFrom(objectValue.getClass()) && dynamicAttribute.getName().equals(propName)).findFirst()).isPresent() || !map.containsKey(propNamePlural = propName.substring(0, propName.length() - this.getConfig().getAttributeIdPluralSuffix().length()) + this.getConfig().getAttributePluralSuffix())) continue;
            Object propValuePlural = map.get(propNamePlural);
            if (propValuePlural instanceof Collection && !((Collection)propValuePlural).isEmpty()) {
                map.remove(propName);
                continue;
            }
            Object propValueIds = map.get(propName);
            if (!(propValueIds instanceof Collection) || ((Collection)propValueIds).isEmpty()) continue;
            map.remove(propNamePlural);
        }
        return map;
    }

    protected Object getArgumentValue(Field queryField, String name, Map<String, Object> arguments) {
        Optional<Argument> argumentOpt = queryField.getArguments().stream().filter(argument -> name.equals(argument.getName())).findFirst();
        if (!argumentOpt.isPresent()) {
            throw new IllegalArgumentException(Message.format("Argument not found with name [{}]", name));
        }
        Object ret = this.mapValue(argumentOpt.get(), arguments);
        return ret;
    }

    protected <T> T createAndSetPropertyValues(Map<String, Object> propertyValues, Class<T> targetClass) {
        try {
            T target = targetClass.newInstance();
            this.setPropertyValues(propertyValues, target);
            return target;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(Message.format("Unable to create target class [{}]", targetClass), e);
        }
    }

    protected void setPropertyValues(Map<String, Object> propertyValues, Object target) {
        propertyValues.entrySet().forEach(entry -> {
            try {
                PropertyUtils.setSimpleProperty((Object)target, (String)((String)entry.getKey()), entry.getValue());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(Message.format("Unsupported property value [{}] for key [{}] on [{}]", entry.getValue(), entry.getKey(), target), e);
            }
        });
    }

    protected GQLInternalMetaModel getMetaModel() {
        return this.metaModel;
    }

    protected GQLSchemaConfig getConfig() {
        return this.schemaConfig;
    }

    private <X> X mapValue(Value<?> value, String argumentName, Map<String, Object> arguments) {
        Map<String, Object> mappedValue = null;
        if (value instanceof ArrayValue) {
            throw new IllegalArgumentException(Message.format("Unsupported value type [{}]", value));
        }
        if (value instanceof BooleanValue) {
            mappedValue = ((BooleanValue)value).isValue();
        } else if (value instanceof EnumValue) {
            mappedValue = ((EnumValue)value).getName();
        } else if (value instanceof FloatValue) {
            mappedValue = ((FloatValue)value).getValue().doubleValue();
        } else if (value instanceof IntValue) {
            mappedValue = ((IntValue)value).getValue().intValue();
        } else if (value instanceof StringValue) {
            mappedValue = ((StringValue)value).getValue();
        } else if (value instanceof VariableReference) {
            mappedValue = arguments.get(argumentName);
        } else if (value instanceof ObjectValue) {
            mappedValue = this.convertObjectValue((ObjectValue)value, this.getArgumentsForContext(arguments, argumentName));
        }
        return (X)mappedValue;
    }

    public void setMetaModel(GQLInternalMetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public void setSchemaConfig(GQLSchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }
}

