/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.datafetcher.GQLAbstractDataFetcher;
import com.daikit.graphql.datafetcher.GQLDynamicAttributeRegistry;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.utils.Message;
import graphql.language.Field;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class GQLAbstractSaveDataFetcher<SUPER_ENTITY_TYPE>
extends GQLAbstractDataFetcher<SUPER_ENTITY_TYPE> {
    private GQLDynamicAttributeRegistry dynamicAttributeRegistry;

    protected abstract void save(SUPER_ENTITY_TYPE var1);

    protected abstract SUPER_ENTITY_TYPE getOrCreateAndSetProperties(Class<?> var1, GQLDynamicAttributeRegistry var2, Map<String, Object> var3);

    protected SUPER_ENTITY_TYPE save(Class<?> entityClass, GQLDynamicAttributeRegistry dynamicAttributeRegistry, Map<String, Object> fieldValueMap) {
        SUPER_ENTITY_TYPE model = this.getOrCreateAndSetProperties(entityClass, dynamicAttributeRegistry, fieldValueMap);
        this.save(model);
        return model;
    }

    public SUPER_ENTITY_TYPE get(DataFetchingEnvironment environment) {
        Map<String, Object> fieldValueMap;
        Field mutationField = environment.getField();
        String entityName = this.getEntityName(this.getConfig().getMutationSavePrefix(), mutationField.getName());
        Value dataValue = mutationField.getArguments().stream().filter(argument -> this.getConfig().getMutationAttributeInputDataName().equals(argument.getName())).findFirst().get().getValue();
        Map<String, Object> arguments = this.getArgumentsForContext(environment.getArguments(), this.getConfig().getMutationAttributeInputDataName());
        Class<?> entityClass = this.getEntityClassByEntityName(entityName);
        if (dataValue instanceof ObjectValue) {
            fieldValueMap = this.convertObjectValue((ObjectValue)dataValue, arguments);
        } else if (dataValue instanceof VariableReference) {
            fieldValueMap = new HashMap<String, Object>(arguments);
            this.mapDynamicAttributeSettersValues(entityClass, fieldValueMap);
        } else {
            throw new GQLException(Message.format("Unsupported save data type : [{}]", dataValue.getClass().getName()));
        }
        return this.save(entityClass, this.dynamicAttributeRegistry, fieldValueMap);
    }

    protected void mapDynamicAttributeSettersValues(Class<?> entityClass, Map<String, Object> fieldValueMap) {
        fieldValueMap.entrySet().forEach(entry -> {
            Optional setter;
            if (entry.getValue() instanceof Map && (setter = this.dynamicAttributeRegistry.getSetter(entityClass, (String)entry.getKey())).isPresent()) {
                entry.setValue(this.convertValue((Map)entry.getValue(), setter.get()));
            }
        });
    }

    protected Object convertValue(Map<String, Object> dynamicAttributeValuePropertyValues, IGQLDynamicAttributeSetter<?, ?> dynamicAttributeSetter) {
        Type type = (Type)GenericsUtils.getTypeArguments(dynamicAttributeSetter.getClass(), IGQLDynamicAttributeSetter.class).get(1);
        Object converted = this.createAndSetPropertyValues(dynamicAttributeValuePropertyValues, GenericsUtils.getTypeClass((Type)type));
        return converted;
    }

    public GQLDynamicAttributeRegistry getDynamicAttributeRegistry() {
        return this.dynamicAttributeRegistry;
    }

    public void setDynamicAttributeRegistry(GQLDynamicAttributeRegistry dynamicAttributeRegistry) {
        this.dynamicAttributeRegistry = dynamicAttributeRegistry;
    }
}

