/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.builder.GQLExecutionContext;
import com.daikit.graphql.custommethod.GQLCustomMethod;
import com.daikit.graphql.custommethod.GQLCustomMethodArg;
import com.daikit.graphql.datafetcher.GQLAbstractDataFetcher;
import com.daikit.graphql.execution.GQLRootContext;
import com.daikit.graphql.utils.Message;
import graphql.GraphQLException;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GQLCustomMethodDataFetcher
extends GQLAbstractDataFetcher<Object> {
    private final Map<String, GQLCustomMethod> allMethods = new HashMap<String, GQLCustomMethod>();

    public void registerCustomMethods(List<? extends GQLCustomMethod> customMethods) {
        customMethods.stream().forEach(customMethod -> {
            GQLCustomMethod existing = this.allMethods.get(customMethod.getName());
            if (existing != null && !existing.equals(customMethod)) {
                throw new GraphQLException(Message.format("Duplicate custom methods registered with name {}.", customMethod.getName()));
            }
            this.allMethods.put(customMethod.getName(), (GQLCustomMethod)customMethod);
        });
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        GQLCustomMethod method = this.allMethods.get(environment.getField().getName());
        List arguments = method.getArgs().stream().map(arg -> this.getArgumentValue(environment, (GQLCustomMethodArg)arg)).collect(Collectors.toList());
        try {
            return method.getMethod().invoke(method.getController(), arguments.toArray());
        }
        catch (InvocationTargetException e) {
            throw e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
        }
    }

    protected <T> T getArgumentValue(DataFetchingEnvironment environment, GQLCustomMethodArg argument) {
        if (GQLExecutionContext.class.isAssignableFrom(GenericsUtils.getTypeClass((Type)argument.getType()))) {
            return (T)((GQLRootContext)environment.getContext()).getExecutionContext();
        }
        if (GQLRootContext.class.isAssignableFrom(GenericsUtils.getTypeClass((Type)argument.getType()))) {
            return (T)((GQLRootContext)environment.getContext());
        }
        Field queryField = environment.getField();
        Object argumentGraphQLValue = this.getArgumentValue(queryField, argument.getName(), environment.getArguments());
        Object mappedValue = argumentGraphQLValue;
        if (mappedValue != null && mappedValue instanceof Map) {
            mappedValue = this.convertValue((Map)mappedValue, argument);
        }
        return (T)mappedValue;
    }

    protected Object convertValue(Map<String, Object> argumentPropertyValues, GQLCustomMethodArg argument) {
        return this.createAndSetPropertyValues(argumentPropertyValues, GenericsUtils.getTypeClass((Type)argument.getType()));
    }
}

