/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GQLFilterOperatorEnum {
    EMPTY("isEmpty", "Field is either null or an empty text. No [value] needed for the related filter."),
    NOT_EMPTY("isNotEmpty", "Field is not null and not an empty text. No [value] needed for the related filter."),
    NULL("isNull", "Field is null. No [value] needed for the related filter."),
    NOT_NULL("isNotNull", "Field is not null. No [value] needed for the related filter."),
    ENDS_WITH("endsWith", "Field ends with text given in [value] property."),
    STARTS_WITH("startsWith", "Field starts with text given in [value] property."),
    CONTAINS("contains", "Field contains text given in [value] property."),
    LIKE("like", "Field is like text given in [value] property. Wildcard character is %."),
    EQUAL("eq", "Field equals text given in [value] property."),
    NOT_EQUAL("neq", "Field is not equal to text given in [value] property."),
    GREATER_THAN("gt", "Field is greater than number given in [value] property."),
    GREATER_EQUAL("ge", "Field is greater or equal to the number given in [value] property."),
    LOWER_THAN("lt", "Field is lower than number given in [value] property."),
    LOWER_EQUAL("le", "Field is lower or equal to the number given in [value] property."),
    IN("in", "Field is contained in list of possible values given in [value] property."),
    NOT_IN("notIn", "Field is not contained in list of possible values given in [value] property."),
    INCLUDES("incl", "Field contains value given in [value] property."),
    INCLUDES_ALL("incl", "Field contains all values given in [value] property."),
    INCLUDES_ONE("incl", "Field at least one of the values given in [value] property.");

    private final String code;
    private final String description;
    private static Map<String, GQLFilterOperatorEnum> MAP;
    public static final List<GQLFilterOperatorEnum> __NUMBER_OPERATORS;
    public static final List<GQLFilterOperatorEnum> __BOOLEAN_OPERATORS;
    public static final List<GQLFilterOperatorEnum> __DATE_OPERATORS;
    public static final List<GQLFilterOperatorEnum> __STRING_OPERATORS;
    public static final List<GQLFilterOperatorEnum> __ID_OPERATORS;
    public static final List<GQLFilterOperatorEnum> __ENUM_OPERATORS;
    public static final List<GQLFilterOperatorEnum> __COLLECTION_OPERATORS;

    private GQLFilterOperatorEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static GQLFilterOperatorEnum forCode(String code) {
        return MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        MAP = new HashMap<String, GQLFilterOperatorEnum>();
        for (GQLFilterOperatorEnum type : GQLFilterOperatorEnum.values()) {
            MAP.put(type.getCode(), type);
        }
        __NUMBER_OPERATORS = Arrays.asList(EQUAL, NOT_EQUAL, GREATER_EQUAL, GREATER_THAN, LOWER_EQUAL, LOWER_THAN, IN, NOT_IN, NULL, NOT_NULL);
        __BOOLEAN_OPERATORS = Arrays.asList(EQUAL, NULL, NOT_NULL);
        __DATE_OPERATORS = Arrays.asList(EQUAL, NOT_EQUAL, GREATER_EQUAL, GREATER_THAN, LOWER_EQUAL, LOWER_THAN, IN, NOT_IN, NULL, NOT_NULL);
        __STRING_OPERATORS = Arrays.asList(EQUAL, NOT_EQUAL, IN, NOT_IN, NULL, NOT_NULL, EMPTY, NOT_EMPTY, STARTS_WITH, ENDS_WITH, CONTAINS, LIKE);
        __ID_OPERATORS = Arrays.asList(EQUAL, NOT_EQUAL, IN, NOT_IN);
        __ENUM_OPERATORS = Arrays.asList(EQUAL, NOT_EQUAL, IN, NOT_IN, NULL, NOT_NULL);
        __COLLECTION_OPERATORS = Arrays.asList(INCLUDES, INCLUDES_ALL, INCLUDES_ONE);
    }
}

