/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.builder.GQLExecutionContext;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.custommethod.GQLCustomMethod;
import com.daikit.graphql.dynamicattribute.IGQLAbstractDynamicAttribute;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeGetter;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import com.daikit.graphql.execution.GQLRootContext;
import com.daikit.graphql.meta.GQLEnumsAndEmbeddedEntities;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GQLEnumsAndEmbeddedEntitiesCollector {
    private final GQLSchemaConfig schemaConfig;

    public GQLEnumsAndEmbeddedEntitiesCollector(GQLSchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    public GQLEnumsAndEmbeddedEntities collect(Collection<Class<?>> entityClasses, Collection<Class<?>> availableEmbeddedEntityClasses, Collection<IGQLAbstractDynamicAttribute<?>> dynamicAttributes, Collection<GQLCustomMethod> methods) {
        GQLEnumsAndEmbeddedEntities collected = new GQLEnumsAndEmbeddedEntities();
        dynamicAttributes.stream().filter(dynamicAttribute -> dynamicAttribute instanceof IGQLDynamicAttributeGetter).forEach(dynamicAttribute -> this.collect(entityClasses, availableEmbeddedEntityClasses, ((IGQLDynamicAttributeGetter)dynamicAttribute).getGetterAttributeType(), collected));
        dynamicAttributes.stream().filter(dynamicAttribute -> dynamicAttribute instanceof IGQLDynamicAttributeSetter).forEach(dynamicAttribute -> this.collect(entityClasses, availableEmbeddedEntityClasses, ((IGQLDynamicAttributeSetter)dynamicAttribute).getSetterAttributeType(), collected));
        methods.forEach(method -> {
            this.collect(entityClasses, availableEmbeddedEntityClasses, method.getOutputType(), collected);
            method.getArgs().forEach(arg -> {
                if (!GQLExecutionContext.class.isAssignableFrom(GenericsUtils.getTypeClass((Type)arg.getType())) && !GQLRootContext.class.isAssignableFrom(GenericsUtils.getTypeClass((Type)arg.getType()))) {
                    this.collect(entityClasses, availableEmbeddedEntityClasses, arg.getType(), collected);
                }
            });
        });
        entityClasses.forEach(entityClass -> FieldUtils.getAllFieldsList((Class)entityClass).forEach(field -> this.collect(entityClasses, availableEmbeddedEntityClasses, field.getGenericType(), collected)));
        return collected;
    }

    private void collect(Collection<Class<?>> entityClasses, Collection<Class<?>> availableEmbeddedEntityClasses, Type attributeType, GQLEnumsAndEmbeddedEntities collected) {
        Class rawClass = GenericsUtils.getTypeClass((Type)attributeType);
        if (Enum.class.isAssignableFrom(rawClass)) {
            collected.getEnums().add(rawClass);
        } else if (Collection.class.isAssignableFrom(rawClass)) {
            this.collect(entityClasses, availableEmbeddedEntityClasses, (Type)GenericsUtils.getTypeArguments((Type)attributeType).get(0), collected);
        } else if (this.isByteArray(rawClass)) {
            this.collect(entityClasses, availableEmbeddedEntityClasses, rawClass.getComponentType(), collected);
        } else if (!(this.schemaConfig.isScalarType(rawClass) || entityClasses.contains(rawClass) || entityClasses.contains(attributeType) || collected.getEntities().contains(rawClass))) {
            this.getWithExtendingClasses(availableEmbeddedEntityClasses, rawClass).forEach(embeddedEntityClass -> {
                collected.getEntities().add((Class<?>)embeddedEntityClass);
                FieldUtils.getAllFieldsList((Class)embeddedEntityClass).forEach(field -> this.collect(entityClasses, availableEmbeddedEntityClasses, field.getGenericType(), collected));
            });
        }
    }

    private boolean isByteArray(Class<?> type) {
        return type.isArray() && this.schemaConfig.isScalarType(type.getComponentType()) && GQLScalarTypeEnum.BYTE.toString().equals(this.schemaConfig.getScalarTypeCodeFromClass(type.getComponentType()).get());
    }

    private Set<Class<?>> getWithExtendingClasses(Collection<Class<?>> availableEmbeddedEntityClasses, Class<?> entityClass) {
        HashSet assignableClasses;
        Set<Class<Object>> set = assignableClasses = availableEmbeddedEntityClasses == null ? new HashSet() : availableEmbeddedEntityClasses.stream().filter(potential -> entityClass.isAssignableFrom((Class<?>)potential)).collect(Collectors.toSet());
        if (!assignableClasses.contains(entityClass)) {
            assignableClasses.add(entityClass);
        }
        return assignableClasses.size() == 1 ? assignableClasses : assignableClasses.stream().flatMap(subClass -> this.getWithExtendingClasses(availableEmbeddedEntityClasses, (Class<?>)subClass).stream()).collect(Collectors.toSet());
    }
}

