/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import java.util.Collection;
import java.util.Optional;

public class GQLAbstractMetaDataBuilder {
    private final GQLSchemaConfig schemaConfig;

    public GQLAbstractMetaDataBuilder(GQLSchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    protected boolean isEnum(Collection<GQLEnumMetaData> enumMetaDatas, Class<?> clazz) {
        return enumMetaDatas.stream().filter(metaData -> metaData.getEnumClass().isAssignableFrom(clazz)).findFirst().isPresent();
    }

    protected boolean isEntity(Collection<GQLEntityMetaData> entityMetaDatas, Class<?> clazz) {
        return this.getEntity(entityMetaDatas, clazz).isPresent();
    }

    protected Optional<GQLEntityMetaData> getEntity(Collection<GQLEntityMetaData> entityMetaDatas, Class<?> clazz) {
        return entityMetaDatas.stream().filter(metaData -> metaData.getEntityClass().isAssignableFrom(clazz)).findFirst();
    }

    protected boolean isByteArray(Class<?> type) {
        return type.isArray() && this.getConfig().isScalarType(type.getComponentType()) && GQLScalarTypeEnum.BYTE.toString().equals(this.getConfig().getScalarTypeCodeFromClass(type.getComponentType()).get());
    }

    protected GQLSchemaConfig getConfig() {
        return this.schemaConfig;
    }
}

