/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import com.daikit.graphql.meta.GQLAttribute;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListScalarMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeScalarMetaData;
import com.daikit.graphql.meta.builder.GQLAbstractAttributeMetaDataBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class GQLAttributeMetaDataBuilder
extends GQLAbstractAttributeMetaDataBuilder {
    private final Collection<Class<?>> allEntityClasses;
    private final Collection<Class<?>> allDataClasses;
    private final Collection<Class<? extends Enum<?>>> allEnumClasses;

    public GQLAttributeMetaDataBuilder(GQLSchemaConfig schemaConfig, Collection<Class<?>> allEntityClasses, Collection<Class<?>> allDataClasses, Collection<Class<? extends Enum<?>>> allEnumClasses) {
        super(schemaConfig);
        this.allEntityClasses = allEntityClasses;
        this.allDataClasses = allDataClasses;
        this.allEnumClasses = allEnumClasses;
    }

    public GQLAbstractAttributeMetaData buildAttribute(Class<?> entityClass, Field field) {
        GQLAttribute annotation;
        GQLAbstractAttributeMetaData attribute = null;
        if (!(Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || (annotation = field.getAnnotation(GQLAttribute.class)) != null && annotation.exclude())) {
            if (this.getConfig().isScalarType(field.getType())) {
                attribute = this.buildGQLAttributeScalar(field);
            } else if (this.isByteArray(field.getType())) {
                attribute = this.buildGQLAttributeScalarArray(field, field.getType().getComponentType());
            } else if (Collection.class.isAssignableFrom(field.getType())) {
                Class genericType = GenericsUtils.getFieldTypeArgumentAsClass(entityClass, (Field)field);
                if (this.getConfig().isScalarType(genericType)) {
                    attribute = this.buildGQLAttributeListScalar(field, genericType);
                } else if (this.allEntityClasses.contains(genericType)) {
                    attribute = this.buildGQLAttributeListEntity(field, genericType, false);
                } else if (this.allDataClasses.contains(genericType)) {
                    attribute = this.buildGQLAttributeListEntity(field, genericType, true);
                } else if (this.allEnumClasses.contains(genericType)) {
                    attribute = this.buildGQLAttributeListEnum(field, genericType);
                }
            } else if (this.allEntityClasses.contains(field.getType())) {
                attribute = this.buildGQLAttributeEntity(field, false);
            } else if (this.allDataClasses.contains(field.getType())) {
                attribute = this.buildGQLAttributeEntity(field, true);
            } else if (this.allEnumClasses.contains(field.getType())) {
                attribute = this.buildGQLAttributeEnum(field);
            }
        }
        return attribute;
    }

    private GQLAttributeScalarMetaData buildGQLAttributeScalar(Field field) {
        GQLAttributeScalarMetaData attribute = new GQLAttributeScalarMetaData();
        this.populateAttributeMetaData(field, attribute);
        if (this.getConfig().getAttributeIdName().equals(field.getName())) {
            attribute.setScalarType(GQLScalarTypeEnum.ID.toString());
            attribute.getRights().stream().forEach(rights -> {
                rights.setNullableForUpdate(false);
                rights.setMandatoryForUpdate(true);
            });
        } else {
            attribute.setScalarType(this.getConfig().getScalarTypeCodeFromClass(field.getType()).get());
        }
        return attribute;
    }

    private GQLAttributeScalarMetaData buildGQLAttributeScalarArray(Field field, Class<?> componentType) {
        GQLAttributeScalarMetaData attribute = new GQLAttributeScalarMetaData();
        this.populateAttributeMetaData(field, attribute);
        attribute.setScalarType(this.getConfig().getScalarTypeCodeFromClass(componentType).get());
        return attribute;
    }

    private GQLAttributeListScalarMetaData buildGQLAttributeListScalar(Field field, Class<?> genericType) {
        GQLAttributeListScalarMetaData attribute = new GQLAttributeListScalarMetaData();
        this.populateAttributeMetaData(field, attribute);
        attribute.setScalarType(this.getConfig().getScalarTypeCodeFromClass(genericType).get());
        return attribute;
    }

    private GQLAttributeEnumMetaData buildGQLAttributeEnum(Field field) {
        GQLAttributeEnumMetaData attribute = new GQLAttributeEnumMetaData();
        this.populateAttributeMetaData(field, attribute);
        attribute.setEnumClass(field.getType());
        return attribute;
    }

    private GQLAttributeListEnumMetaData buildGQLAttributeListEnum(Field field, Class<?> foreignClass) {
        GQLAttributeListEnumMetaData attribute = new GQLAttributeListEnumMetaData();
        this.populateAttributeMetaData(field, attribute);
        attribute.setEnumClass(foreignClass);
        return attribute;
    }

    private GQLAttributeEntityMetaData buildGQLAttributeEntity(Field field, boolean embedded) {
        GQLAttributeEntityMetaData attribute = new GQLAttributeEntityMetaData();
        this.populateAttributeMetaData(field, attribute);
        attribute.setEntityClass(field.getType());
        attribute.setEmbedded(embedded);
        return attribute;
    }

    private GQLAttributeListEntityMetaData buildGQLAttributeListEntity(Field field, Class<?> foreignClass, boolean embedded) {
        GQLAttributeListEntityMetaData attribute = new GQLAttributeListEntityMetaData();
        this.populateAttributeMetaData(field, attribute);
        attribute.setForeignClass(foreignClass);
        attribute.setEmbedded(embedded);
        return attribute;
    }

    private void populateAttributeMetaData(Field field, GQLAbstractAttributeMetaData gqlAttribute) {
        GQLAttribute annotation = field.getAnnotation(GQLAttribute.class);
        gqlAttribute.setName(annotation == null || StringUtils.isEmpty((CharSequence)annotation.name()) ? field.getName() : annotation.name());
        gqlAttribute.setDescription(annotation == null ? null : annotation.description());
        this.populateAttributeRights(gqlAttribute, annotation);
        gqlAttribute.setFilterable(annotation == null || annotation.filter());
    }
}

