/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.graphql.custommethod.GQLCustomMethod;
import com.daikit.graphql.custommethod.GQLCustomMethodArg;
import com.daikit.graphql.meta.GQLMethod;
import com.daikit.graphql.meta.GQLParam;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GQLControllerMethodCollector {
    public List<GQLCustomMethod> collect(Collection<Object> controllers) {
        ArrayList<GQLCustomMethod> customMethods = new ArrayList<GQLCustomMethod>();
        for (Object controller : controllers) {
            Method[] methods;
            for (Method method : methods = controller.getClass().getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(GQLMethod.class)) continue;
                customMethods.add(this.collectMethod(controller, method));
            }
        }
        return customMethods;
    }

    private GQLCustomMethod collectMethod(Object controller, Method method) {
        GQLCustomMethod customMethod = new GQLCustomMethod();
        GQLMethod methodAnnotation = method.getAnnotation(GQLMethod.class);
        customMethod.setName(StringUtils.isEmpty((CharSequence)methodAnnotation.value()) ? method.getName() : methodAnnotation.value());
        customMethod.setDescription(methodAnnotation.description());
        customMethod.setType(methodAnnotation.type());
        customMethod.setOutputType(method.getGenericReturnType());
        customMethod.setController(controller);
        customMethod.setMethod(method);
        for (Parameter parameter : method.getParameters()) {
            GQLCustomMethodArg arg = new GQLCustomMethodArg();
            GQLParam paramAnnotation = parameter.getAnnotation(GQLParam.class);
            arg.setName(paramAnnotation != null && StringUtils.isNotEmpty((CharSequence)paramAnnotation.value()) ? paramAnnotation.value() : parameter.getName());
            arg.setType(parameter.getParameterizedType());
            customMethod.getArgs().add(arg);
        }
        return customMethod;
    }
}

