/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.dynamicattribute.IGQLAbstractDynamicAttribute;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeGetter;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import com.daikit.graphql.meta.GQLAttribute;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEntityMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListEnumMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeListScalarMetaData;
import com.daikit.graphql.meta.attribute.GQLAttributeScalarMetaData;
import com.daikit.graphql.meta.builder.GQLAbstractAttributeMetaDataBuilder;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.utils.Message;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class GQLDynamicAttributeMetaDataBuilder
extends GQLAbstractAttributeMetaDataBuilder {
    public GQLDynamicAttributeMetaDataBuilder(GQLSchemaConfig schemaConfig) {
        super(schemaConfig);
    }

    public List<GQLAbstractAttributeMetaData> build(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, IGQLAbstractDynamicAttribute<?> attribute) {
        GQLAttribute annotation = attribute.getClass().getAnnotation(GQLAttribute.class);
        ArrayList<GQLAbstractAttributeMetaData> attributeMetaDatas = new ArrayList<GQLAbstractAttributeMetaData>();
        if (annotation == null || !annotation.exclude()) {
            Type attributeType;
            if (attribute instanceof IGQLDynamicAttributeGetter) {
                attributeType = (Type)GenericsUtils.getTypeArguments(attribute.getClass(), IGQLDynamicAttributeGetter.class).get(1);
                boolean filterable = StringUtils.isNotEmpty((CharSequence)((IGQLDynamicAttributeGetter)attribute).getFilterQueryPath());
                GQLAbstractAttributeMetaData attributeMetaData = this.createAttributeMetaData(enumMetaDatas, entityMetaDatas, attributeType, attribute);
                this.populate(attribute, annotation, true, false, filterable, attributeMetaData);
                attributeMetaData.setDynamicAttributeGetter((IGQLDynamicAttributeGetter)attribute);
                attributeMetaDatas.add(attributeMetaData);
            }
            if (attribute instanceof IGQLDynamicAttributeSetter) {
                attributeType = (Type)GenericsUtils.getTypeArguments(attribute.getClass(), IGQLDynamicAttributeSetter.class).get(1);
                GQLAbstractAttributeMetaData attributeMetaData = this.createAttributeMetaData(enumMetaDatas, entityMetaDatas, attributeType, attribute);
                this.populate(attribute, annotation, false, true, false, attributeMetaData);
                attributeMetaData.setDynamicAttributeSetter((IGQLDynamicAttributeSetter)attribute);
                attributeMetaDatas.add(attributeMetaData);
            }
            if (!(attribute instanceof IGQLDynamicAttributeGetter) && !(attribute instanceof IGQLDynamicAttributeSetter)) {
                throw new IllegalArgumentException("Unsupported dynamic attribute type for : " + attribute.getClass().getName());
            }
        }
        return attributeMetaDatas;
    }

    private void populate(IGQLAbstractDynamicAttribute<?> attribute, GQLAttribute annotation, boolean readable, boolean saveable, boolean filterable, GQLAbstractAttributeMetaData attributeMetaData) {
        this.populateAttributeRights(attributeMetaData, annotation, readable, saveable);
        attributeMetaData.setFilterable(filterable);
        attributeMetaData.setName(attribute.getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GQLAbstractAttributeMetaData createAttributeMetaData(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, Type attributeType, IGQLAbstractDynamicAttribute<?> attribute) {
        void var5_13;
        Class attributeRawClass = GenericsUtils.getTypeClass((Type)attributeType);
        if (this.getConfig().isScalarType(attributeRawClass) || attributeRawClass.isArray() && this.getConfig().isScalarType(attributeRawClass.getComponentType()) && GQLScalarTypeEnum.BYTE.toString().equals(this.getConfig().getScalarTypeCodeFromClass(attributeRawClass.getComponentType()).get())) {
            GQLAttributeScalarMetaData gQLAttributeScalarMetaData = new GQLAttributeScalarMetaData();
            gQLAttributeScalarMetaData.setScalarType(this.getConfig().getScalarTypeCodeFromClass(attributeRawClass).get());
            return var5_13;
        } else if (this.isEnum(enumMetaDatas, attributeRawClass)) {
            GQLAttributeEnumMetaData gQLAttributeEnumMetaData = new GQLAttributeEnumMetaData();
            gQLAttributeEnumMetaData.setEnumClass(attributeRawClass);
            return var5_13;
        } else {
            Optional<GQLEntityMetaData> optionalEntity = this.getEntity(entityMetaDatas, attributeRawClass);
            if (optionalEntity.isPresent()) {
                GQLAttributeEntityMetaData gQLAttributeEntityMetaData = new GQLAttributeEntityMetaData();
                gQLAttributeEntityMetaData.setEntityClass(attributeRawClass);
                gQLAttributeEntityMetaData.setEmbedded(optionalEntity.get().isEmbedded());
                return var5_13;
            } else {
                if (!Collection.class.isAssignableFrom(attributeRawClass)) throw new IllegalArgumentException(Message.format("Not handled  dynamic attribute [{}] on [{}] type [{}].", attribute.getName(), attribute.getEntityType().getName(), attributeRawClass.getSimpleName()));
                Class foreignClass = (Class)GenericsUtils.getTypeArgumentsAsClasses((Type)attributeType, Collection.class).get(0);
                if (this.getConfig().isScalarType(foreignClass)) {
                    GQLAttributeListScalarMetaData gQLAttributeListScalarMetaData = new GQLAttributeListScalarMetaData();
                    gQLAttributeListScalarMetaData.setScalarType(this.getConfig().getScalarTypeCodeFromClass(foreignClass).get());
                    return var5_13;
                } else if (this.isEnum(enumMetaDatas, foreignClass)) {
                    GQLAttributeListEnumMetaData gQLAttributeListEnumMetaData = new GQLAttributeListEnumMetaData();
                    gQLAttributeListEnumMetaData.setEnumClass(foreignClass);
                    return var5_13;
                } else {
                    Optional<GQLEntityMetaData> optionalForeignEntity = this.getEntity(entityMetaDatas, foreignClass);
                    if (!optionalForeignEntity.isPresent()) throw new IllegalArgumentException(Message.format("Not handled dynamic attribute [{}] on [{}] collection type [{}].", attribute.getName(), attribute.getEntityType().getName(), foreignClass.getName()));
                    GQLAttributeListEntityMetaData gQLAttributeListEntityMetaData = new GQLAttributeListEntityMetaData();
                    gQLAttributeListEntityMetaData.setForeignClass(foreignClass);
                    gQLAttributeListEntityMetaData.setEmbedded(optionalForeignEntity.get().isEmbedded());
                }
            }
        }
        return var5_13;
    }
}

