/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.entity;

import com.daikit.graphql.builder.GQLExecutionContext;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.meta.GQLAbstractMetaData;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.entity.GQLEntityRightsMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class GQLEntityMetaData
extends GQLAbstractMetaData {
    private boolean embedded = false;
    private boolean concrete = true;
    private List<GQLEntityRightsMetaData> rights = new ArrayList<GQLEntityRightsMetaData>();
    private String name;
    private String description;
    private Class<?> superEntityClass;
    private Class<?> entityClass;
    private List<GQLAbstractAttributeMetaData> attributes = new ArrayList<GQLAbstractAttributeMetaData>();
    private final GQLEntityRightsMetaData DEFAULT_RIGHTS = new GQLEntityRightsMetaData();

    public GQLEntityMetaData() {
    }

    public GQLEntityMetaData(String name, Class<?> entityClass) {
        this.name = name;
        this.entityClass = entityClass;
    }

    public GQLEntityMetaData(String name, Class<?> entityClass, boolean concrete) {
        this.name = name;
        this.entityClass = entityClass;
        this.concrete = concrete;
    }

    public GQLEntityMetaData(String name, Class<?> entityClass, Class<?> superEntityClass) {
        this.name = name;
        this.entityClass = entityClass;
        this.superEntityClass = superEntityClass;
    }

    public GQLEntityMetaData(String name, Class<?> entityClass, Class<?> superEntityClass, boolean concrete) {
        this.name = name;
        this.entityClass = entityClass;
        this.superEntityClass = superEntityClass;
        this.concrete = concrete;
    }

    @Override
    protected void appendToString(StringBuilder stringBuilder) {
        stringBuilder.append(this.concrete ? "" : "[ABS]");
        stringBuilder.append("[").append(this.entityClass == null ? "" : this.entityClass.getSimpleName());
        stringBuilder.append(this.superEntityClass == null ? "" : " EXTENDS " + this.superEntityClass.getSimpleName()).append("]");
        stringBuilder.append("[ATTR=").append(this.attributes.size()).append("])");
    }

    public void addAttribute(GQLAbstractAttributeMetaData attribute) {
        if (attribute != null) {
            this.attributes.add(attribute);
        }
    }

    public boolean isSaveable(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isSaveable());
    }

    public boolean isReadable(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isReadable());
    }

    public boolean isDeletable(GQLExecutionContext executionContext) {
        return this.checkRights(executionContext, rights -> rights.isDeletable());
    }

    public GQLEntityMetaData addRights(GQLEntityRightsMetaData ... rightsArray) {
        Stream.of(rightsArray).forEach(rights -> {
            this.getRights().stream().filter(r -> Objects.equals(r.getRole(), rights.getRole())).findFirst().ifPresent(r -> {
                throw new GQLException("Several rights configured for same role [" + r.getRole() + "] within entity [" + this + "]");
            });
            if (rights.getRole() == null) {
                this.getRights().add(0, (GQLEntityRightsMetaData)rights);
            } else {
                this.getRights().add((GQLEntityRightsMetaData)rights);
            }
        });
        return this;
    }

    private Stream<GQLEntityRightsMetaData> getRights(List<?> roles) {
        return this.getRights().stream().filter(rights -> rights.getRole() == null || roles.contains(rights.getRole()));
    }

    private boolean checkRights(GQLExecutionContext executionContext, Predicate<GQLEntityRightsMetaData> predicate) {
        return this.getRights().isEmpty() ? predicate.test(this.DEFAULT_RIGHTS) : (GQLExecutionContext.GQLRolesJunctionEnum.AND.equals((Object)executionContext.getRolesJunction()) ? this.getRights(executionContext.getRoles()).allMatch(predicate) : this.getRights(executionContext.getRoles()).anyMatch(predicate));
    }

    public List<GQLEntityRightsMetaData> getRights() {
        return this.rights;
    }

    public void setRights(List<GQLEntityRightsMetaData> rights) {
        this.rights = rights;
    }

    public String getDescription() {
        return this.description;
    }

    public GQLEntityMetaData setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public GQLEntityMetaData setConcrete(boolean concrete) {
        this.concrete = concrete;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public GQLEntityMetaData setName(String name) {
        this.name = name;
        return this;
    }

    public Class<?> getSuperEntityClass() {
        return this.superEntityClass;
    }

    public GQLEntityMetaData setSuperEntityClass(Class<?> superEntityClass) {
        this.superEntityClass = superEntityClass;
        return this;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public GQLEntityMetaData setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public List<GQLAbstractAttributeMetaData> getAttributes() {
        return this.attributes;
    }

    public GQLEntityMetaData setAttributes(List<GQLAbstractAttributeMetaData> attributes) {
        this.attributes = attributes;
        return this;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public GQLEntityMetaData setEmbedded(boolean embedded) {
        this.embedded = embedded;
        return this;
    }
}

