/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.GQLSchemaBuilderUtils;
import com.daikit.graphql.builder.types.GQLAbstractTypesBuilder;
import com.daikit.graphql.datafetcher.GQLConcreteSubEntityPropertyDataFetcher;
import com.daikit.graphql.datafetcher.GQLPropertyDataFetcher;
import com.daikit.graphql.meta.GQLMetaModel;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLConcreteEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLInterfaceEntityMetaDataInfos;
import com.daikit.graphql.utils.Message;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GQLEntityTypesBuilder
extends GQLAbstractTypesBuilder {
    public GQLEntityTypesBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildEntityTypes(GQLMetaModel metaModel, List<GQLPropertyDataFetcher<?>> propertiesDataFetchers) {
        this.logger.debug("START building entity types...");
        for (GQLConcreteEntityMetaDataInfos gQLConcreteEntityMetaDataInfos : metaModel.getAllConcretes()) {
            List<GQLPropertyDataFetcher<?>> dataFetchers = propertiesDataFetchers.stream().filter(propertyDataFetcher -> propertyDataFetcher.getEntityClass().isAssignableFrom(gQLConcreteEntityMetaDataInfos.getEntity().getEntityClass())).collect(Collectors.toList());
            this.getCache().getObjectTypes().put(gQLConcreteEntityMetaDataInfos.getEntity().getEntityClass(), this.buildEntity(gQLConcreteEntityMetaDataInfos, dataFetchers));
        }
        for (GQLInterfaceEntityMetaDataInfos gQLInterfaceEntityMetaDataInfos : metaModel.getEmbeddedInterfaces()) {
            this.getCache().getObjectTypes().put(gQLInterfaceEntityMetaDataInfos.getEntity().getEntityClass(), this.buildEmbeddedInterface(gQLInterfaceEntityMetaDataInfos));
        }
        this.logger.debug("END building entity types");
    }

    private GraphQLObjectType buildEntity(GQLAbstractEntityMetaDataInfos infos, List<GQLPropertyDataFetcher<?>> entityPropertiesDataFetchers) {
        this.logger.debug(Message.format("Build entity type [{}]", infos.getEntity().getName()));
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name(infos.getEntity().getName());
        builder.description("Object type for entity [" + infos.getEntity().getName() + "]");
        ArrayList<GraphQLFieldDefinition> fieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        GraphQLFieldDefinition idFieldDefinition = null;
        if (!infos.getEntity().isEmbedded()) {
            idFieldDefinition = this.buildIdFieldDefinition();
            fieldDefinitions.add(idFieldDefinition);
        }
        if (!infos.getEntity().isEmbedded()) {
            infos.getSuperInterfaces().forEach(superInterface -> {
                GraphQLInterfaceType interfaceType = this.getCache().getInterfaceTypes().get(superInterface.getEntity().getEntityClass());
                builder.withInterface(interfaceType);
                GQLSchemaBuilderUtils.addOrReplaceFieldDefinitions(fieldDefinitions, interfaceType.getFieldDefinitions());
            });
        }
        Map<GQLAbstractAttributeMetaData, GraphQLFieldDefinition> entityFieldDefinitions = this.buildEntityFieldDefinitions(infos.getEntity());
        GQLSchemaBuilderUtils.addOrReplaceFieldDefinitions(fieldDefinitions, entityFieldDefinitions.values());
        builder.fields(fieldDefinitions);
        GraphQLObjectType objectType = builder.build();
        if (fieldDefinitions.contains(idFieldDefinition)) {
            this.registerIdDataFetcher((GraphQLFieldsContainer)objectType, idFieldDefinition, entityPropertiesDataFetchers);
        }
        this.registerOtherDataFetchers((GraphQLFieldsContainer)objectType, entityFieldDefinitions, entityPropertiesDataFetchers);
        return objectType;
    }

    private GraphQLObjectType buildEmbeddedInterface(GQLInterfaceEntityMetaDataInfos infos) {
        this.logger.debug(Message.format("Build embedded abstract entity type [{}]", infos.getEntity().getName()));
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name(infos.getEntity().getName());
        builder.description("Object type for embedded abstract entity [" + infos.getEntity().getName() + "]");
        Map fieldDefinitions = infos.getConcreteSubEntities().stream().collect(LinkedHashMap::new, (map, concreteSubEntityType) -> map.put(concreteSubEntityType, this.buildConcreteEmbeddedExtendingType((GQLConcreteEntityMetaDataInfos)concreteSubEntityType)), Map::putAll);
        builder.fields(new ArrayList(fieldDefinitions.values()));
        GraphQLObjectType objectType = builder.build();
        fieldDefinitions.entrySet().stream().forEach(entry -> this.getCache().getCodeRegistryBuilder().dataFetcher((GraphQLFieldsContainer)objectType, (GraphQLFieldDefinition)entry.getValue(), (DataFetcher)new GQLConcreteSubEntityPropertyDataFetcher(((GQLConcreteEntityMetaDataInfos)entry.getKey()).getEntity().getEntityClass())));
        return objectType;
    }

    private GraphQLFieldDefinition buildConcreteEmbeddedExtendingType(GQLConcreteEntityMetaDataInfos concreteSubEntityType) {
        this.logger.debug("Build field definition for concrete embedded extending type [{}]", (Object)concreteSubEntityType.getEntity().getName());
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        String name = "type" + concreteSubEntityType.getEntity().getName();
        GraphQLTypeReference type = new GraphQLTypeReference(this.getCache().getEntityTypeName(concreteSubEntityType.getEntity().getEntityClass()));
        builder.name(name);
        builder.description("Field definition [object-embedded] [" + name + "] for concrete sub type [" + concreteSubEntityType.getEntity().getName() + "] within [" + concreteSubEntityType.getSuperEntity().getEntity().getName() + "]");
        builder.type((GraphQLOutputType)type);
        this.logger.debug(Message.format("Field definition created for [{}] with type [{}]", name, GQLSchemaBuilderUtils.typeToString((GraphQLType)type)));
        return builder.build();
    }
}

