/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLAbstractTypesBuilder;
import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import org.apache.commons.lang3.StringUtils;

public class GQLQueryPagingOutputTypeBuilder
extends GQLAbstractTypesBuilder {
    public GQLQueryPagingOutputTypeBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildPagingOutputType() {
        this.logger.debug("Build paging output type");
        this.getCache().setPagingOutputObjectType((GraphQLOutputType)this.buildPagingOutputObjectType());
    }

    private GraphQLObjectType buildPagingOutputObjectType() {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name(StringUtils.capitalize((String)"paging") + "OutputType");
        builder.description("Paging informations. Only meaningful for paging requests.");
        GraphQLFieldDefinition.Builder limitBuilder = GraphQLFieldDefinition.newFieldDefinition();
        limitBuilder.name("limit");
        limitBuilder.description("How many results this query load contains at maximum. This is equal to the limit passed as parameter.");
        limitBuilder.type((GraphQLOutputType)Scalars.GraphQLInt);
        builder.field(limitBuilder.build());
        GraphQLFieldDefinition.Builder offsetBuilder = GraphQLFieldDefinition.newFieldDefinition();
        offsetBuilder.name("offset");
        offsetBuilder.description("Offset of the results for this query. This is equal to the offset passed as parameters. This is equal to the offset passed as parameter.");
        offsetBuilder.type((GraphQLOutputType)Scalars.GraphQLInt);
        builder.field(offsetBuilder.build());
        GraphQLFieldDefinition.Builder totalLengthBuilder = GraphQLFieldDefinition.newFieldDefinition();
        totalLengthBuilder.name("totalLength");
        totalLengthBuilder.description("Total number of results on the database for this query.");
        totalLengthBuilder.type((GraphQLOutputType)Scalars.GraphQLLong);
        builder.field(totalLengthBuilder.build());
        return builder.build();
    }
}

