/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.execution;

import com.daikit.graphql.data.output.GQLExecutionErrorDetails;
import com.daikit.graphql.execution.IGQLErrorProcessor;
import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import java.util.List;

public class GQLErrorProcessor
implements IGQLErrorProcessor {
    @Override
    public GQLExecutionErrorDetails handleError(List<GraphQLError> errors) {
        GQLExecutionErrorDetails error = null;
        if (errors.size() == 1 && errors.get(0) instanceof ExceptionWhileDataFetching) {
            error = this.handleError(((ExceptionWhileDataFetching)errors.get(0)).getException());
        } else if (!errors.isEmpty()) {
            error = this.createError();
            error.setType("GQLClientError");
            error.setMessage((errors.size() <= 1 ? "An error" : "Multiple errors") + " happened while processing client request");
        }
        return error;
    }

    @Override
    public GQLExecutionErrorDetails handleError(Throwable exception) {
        GQLExecutionErrorDetails error = this.createError();
        error.setMessage(exception.getMessage());
        error.setType(exception.getClass().getSimpleName());
        error.setWrappedException(exception);
        return error;
    }

    protected GQLExecutionErrorDetails createError() {
        return new GQLExecutionErrorDetails();
    }
}

