/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Value;
import java.time.LocalDate;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Date
extends Value {
    private final LocalDate value;

    public Date(int value) {
        this.value = LocalDate.ofEpochDay(value);
    }

    @Override
    public ValueOuterClass.Value toProto() {
        return ValueOuterClass.Value.newBuilder().setDate((int)this.value.toEpochDay()).build();
    }

    public @NonNull LocalDate getValue() {
        return this.value;
    }

    public String toString() {
        return "Date{value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Date date = (Date)o;
        return Objects.equals(this.value, date.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

