/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DamlRecord
extends Value {
    private final Optional<Identifier> recordId;
    private final Map<String, Value> fieldsMap;
    private final List<Field> fields;

    public DamlRecord(@NonNull Identifier recordId, Field ... fields) {
        this(recordId, Arrays.asList(fields));
    }

    public DamlRecord(Field ... fields) {
        this(Arrays.asList(fields));
    }

    public DamlRecord(@NonNull Identifier recordId, @NonNull List<@NonNull Field> fields) {
        this(Optional.of(recordId), fields, DamlRecord.fieldsListToHashMap(fields));
    }

    public DamlRecord(@NonNull List<@NonNull Field> fields) {
        this(Optional.empty(), fields, DamlRecord.fieldsListToHashMap(fields));
    }

    public DamlRecord(@NonNull Optional<Identifier> recordId, @NonNull List<@NonNull Field> fields, Map<String, Value> fieldsMap) {
        this.recordId = recordId;
        this.fields = fields;
        this.fieldsMap = fieldsMap;
    }

    private static Map<String, Value> fieldsListToHashMap(@NonNull List<@NonNull Field> fields) {
        if (fields.isEmpty() || !fields.get(0).getLabel().isPresent()) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> fieldsMap = new HashMap<String, Value>(fields.size());
        for (Field field : fields) {
            fieldsMap.put(field.getLabel().get(), field.getValue());
        }
        return fieldsMap;
    }

    public static @NonNull DamlRecord fromProto(ValueOuterClass.Record record) {
        ArrayList<Field> fields = new ArrayList<Field>(record.getFieldsCount());
        HashMap<String, Value> fieldsMap = new HashMap<String, Value>(record.getFieldsCount());
        for (ValueOuterClass.RecordField recordField : record.getFieldsList()) {
            Field field = Field.fromProto(recordField);
            fields.add(field);
            if (!field.getLabel().isPresent()) continue;
            fieldsMap.put(field.getLabel().get(), field.getValue());
        }
        if (record.hasRecordId()) {
            Identifier recordId = Identifier.fromProto(record.getRecordId());
            return new DamlRecord(Optional.of(recordId), fields, fieldsMap);
        }
        return new DamlRecord(Optional.empty(), fields, fieldsMap);
    }

    @Override
    public ValueOuterClass.Value toProto() {
        return ValueOuterClass.Value.newBuilder().setRecord(this.toProtoRecord()).build();
    }

    public ValueOuterClass.Record toProtoRecord() {
        ValueOuterClass.Record.Builder recordBuilder = ValueOuterClass.Record.newBuilder();
        this.recordId.ifPresent(recordId -> recordBuilder.setRecordId(recordId.toProto()));
        for (Field field : this.fields) {
            recordBuilder.addFields(field.toProto());
        }
        return recordBuilder.build();
    }

    public @NonNull Optional<Identifier> getRecordId() {
        return this.recordId;
    }

    public @NonNull List<Field> getFields() {
        return this.fields;
    }

    public @NonNull Map<@NonNull String, @NonNull Value> getFieldsMap() {
        return this.fieldsMap;
    }

    public String toString() {
        return "DamlRecord{recordId=" + this.recordId + ", fields=" + this.fields + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamlRecord record = (DamlRecord)o;
        return Objects.equals(this.recordId, record.recordId) && Objects.equals(this.fields, record.fields);
    }

    public int hashCode() {
        return Objects.hash(this.recordId, this.fields);
    }

    public static class Field {
        private final Optional<String> label;
        private final Value value;

        public Field(@NonNull String label, @NonNull Value value) {
            this.label = Optional.of(label);
            this.value = value;
        }

        public Field(@NonNull Value value) {
            this.label = Optional.empty();
            this.value = value;
        }

        public @NonNull Optional<String> getLabel() {
            return this.label;
        }

        public @NonNull Value getValue() {
            return this.value;
        }

        public static Field fromProto(ValueOuterClass.RecordField field) {
            String label = field.getLabel();
            Value value = Value.fromProto(field.getValue());
            return label.isEmpty() ? new Field(value) : new Field(label, value);
        }

        public ValueOuterClass.RecordField toProto() {
            ValueOuterClass.RecordField.Builder builder = ValueOuterClass.RecordField.newBuilder();
            this.label.ifPresent(builder::setLabel);
            builder.setValue(this.value.toProto());
            return builder.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return Objects.equals(this.label, field.label) && Objects.equals(this.value, field.value);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.value);
        }

        public String toString() {
            return "Field{label=" + this.label + ", value=" + this.value + '}';
        }
    }
}

