/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Value;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DamlOptional
extends Value {
    public static DamlOptional EMPTY = new DamlOptional(Optional.empty());
    private final Value value;

    DamlOptional(Value value) {
        this.value = value;
    }

    @Deprecated
    public DamlOptional(Optional<@NonNull Value> value) {
        this((Value)value.orElse(null));
    }

    public static DamlOptional of(@NonNull Optional<@NonNull Value> value) {
        if (value.isPresent()) {
            return new DamlOptional(value.get());
        }
        return EMPTY;
    }

    public static DamlOptional of(Value value) {
        return new DamlOptional(value);
    }

    public Optional<Value> getValue() {
        return Optional.ofNullable(this.value);
    }

    public <V> @NonNull Optional<V> toOptional(Function<@NonNull Value, @NonNull V> valueMapper) {
        return this.value == null ? Optional.empty() : Optional.of(valueMapper.apply(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamlOptional optional = (DamlOptional)o;
        return Objects.equals(this.value, optional.value);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public @NonNull String toString() {
        return "Optional{value=" + this.value + '}';
    }

    @Deprecated
    public static @NonNull DamlOptional empty() {
        return EMPTY;
    }

    @Override
    public ValueOuterClass.Value toProto() {
        ValueOuterClass.Optional.Builder ob = ValueOuterClass.Optional.newBuilder();
        if (this.value != null) {
            ob.setValue(this.value.toProto());
        }
        return ValueOuterClass.Value.newBuilder().setOptional(ob.build()).build();
    }

    public static DamlOptional fromProto(ValueOuterClass.Optional optional) {
        return optional.hasValue() ? new DamlOptional(DamlOptional.fromProto(optional.getValue())) : EMPTY;
    }
}

