/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionFilterOuterClass;
import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.Identifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class InclusiveFilter
extends Filter {
    private Set<Identifier> templateIds;

    public InclusiveFilter(@NonNull Set<@NonNull Identifier> templateIds) {
        this.templateIds = templateIds;
    }

    public @NonNull Set<@NonNull Identifier> getTemplateIds() {
        return this.templateIds;
    }

    @Override
    public TransactionFilterOuterClass.Filters toProto() {
        ArrayList<ValueOuterClass.Identifier> templateIds = new ArrayList<ValueOuterClass.Identifier>(this.templateIds.size());
        for (Identifier identifier : this.templateIds) {
            templateIds.add(identifier.toProto());
        }
        TransactionFilterOuterClass.InclusiveFilters inclusiveFilter = TransactionFilterOuterClass.InclusiveFilters.newBuilder().addAllTemplateIds(templateIds).build();
        return TransactionFilterOuterClass.Filters.newBuilder().setInclusive(inclusiveFilter).build();
    }

    public static InclusiveFilter fromProto(TransactionFilterOuterClass.InclusiveFilters inclusiveFilters) {
        HashSet<Identifier> templateIds = new HashSet<Identifier>(inclusiveFilters.getTemplateIdsCount());
        for (ValueOuterClass.Identifier templateId : inclusiveFilters.getTemplateIdsList()) {
            templateIds.add(Identifier.fromProto(templateId));
        }
        return new InclusiveFilter(templateIds);
    }

    public String toString() {
        return "InclusiveFilter{templateIds=" + this.templateIds + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InclusiveFilter that = (InclusiveFilter)o;
        return Objects.equals(this.templateIds, that.templateIds);
    }

    public int hashCode() {
        return Objects.hash(this.templateIds);
    }
}

