/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.EventOuterClass;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.Identifier;
import com.google.protobuf.StringValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ArchivedEvent
implements Event {
    private final List<String> witnessParties;
    private final String eventId;
    private final Identifier templateId;
    private final String contractId;
    private final Optional<String> packageName;

    public ArchivedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull String eventId, @NonNull Identifier templateId, @NonNull String contractId, @NonNull Optional<String> packageName) {
        this.witnessParties = witnessParties;
        this.eventId = eventId;
        this.templateId = templateId;
        this.contractId = contractId;
        this.packageName = packageName;
    }

    @Override
    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    @Override
    public @NonNull String getEventId() {
        return this.eventId;
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    @Override
    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull Optional<String> getPackageName() {
        return this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedEvent that = (ArchivedEvent)o;
        return Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.eventId, that.eventId) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.packageName, that.packageName);
    }

    public int hashCode() {
        return Objects.hash(this.witnessParties, this.eventId, this.templateId, this.contractId, this.packageName);
    }

    public String toString() {
        return "ArchivedEvent{witnessParties=" + this.witnessParties + ", eventId='" + this.eventId + "', templateId=" + this.templateId + ", contractId='" + this.contractId + "', packageName=" + this.packageName + "}";
    }

    public EventOuterClass.ArchivedEvent toProto() {
        EventOuterClass.ArchivedEvent.Builder builder = EventOuterClass.ArchivedEvent.newBuilder().setContractId(this.getContractId()).setEventId(this.getEventId()).setTemplateId(this.getTemplateId().toProto()).addAllWitnessParties(this.getWitnessParties());
        this.packageName.ifPresent(a -> builder.setPackageName(StringValue.of((String)a)));
        return builder.build();
    }

    public static ArchivedEvent fromProto(EventOuterClass.ArchivedEvent archivedEvent) {
        return new ArchivedEvent((List<String>)archivedEvent.getWitnessPartiesList(), archivedEvent.getEventId(), Identifier.fromProto(archivedEvent.getTemplateId()), archivedEvent.getContractId(), archivedEvent.hasPackageName() ? Optional.of(archivedEvent.getPackageName().getValue()) : Optional.empty());
    }
}

