/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Identifier;
import com.google.protobuf.ByteString;
import java.util.Objects;

public final class DisclosedContract {
    public final Identifier templateId;
    public final String contractId;
    public final ByteString createdEventBlob;

    public DisclosedContract(Identifier templateId, String contractId, ByteString createdEventBlob) {
        this.templateId = templateId;
        this.contractId = contractId;
        this.createdEventBlob = createdEventBlob;
    }

    public CommandsOuterClass.DisclosedContract toProto() {
        return CommandsOuterClass.DisclosedContract.newBuilder().setTemplateId(this.templateId.toProto()).setContractId(this.contractId).setCreatedEventBlob(this.createdEventBlob).build();
    }

    public static DisclosedContract fromProto(CommandsOuterClass.DisclosedContract disclosedContract) {
        Identifier templateId = Identifier.fromProto(disclosedContract.getTemplateId());
        String contractId = disclosedContract.getContractId();
        ByteString createdEventBlob = disclosedContract.getCreatedEventBlob();
        return new DisclosedContract(templateId, contractId, createdEventBlob);
    }

    public String toString() {
        return "DisclosedContract{templateId=" + this.templateId + ", contractId='" + this.contractId + "', createdEventBlob='" + this.createdEventBlob + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisclosedContract that = (DisclosedContract)o;
        return Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.createdEventBlob, that.createdEventBlob);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.contractId, this.createdEventBlob);
    }
}

