/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionFilterOuterClass;
import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class InclusiveFilter
extends Filter {
    private Set<Identifier> templateIds;
    private Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceFilters;
    private Map<@NonNull Identifier, @NonNull Filter.Template> templateFilters;

    private InclusiveFilter(@NonNull Set<@NonNull Identifier> templateIds, @NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceFilters, @NonNull Map<@NonNull Identifier, @NonNull Filter.Template> templateFilters) {
        this.templateIds = templateIds;
        this.interfaceFilters = interfaceFilters;
        this.templateFilters = templateFilters;
    }

    public InclusiveFilter(@NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceFilters, @NonNull Map<@NonNull Identifier, @NonNull Filter.Template> templateFilters) {
        this(Collections.emptySet(), interfaceFilters, templateFilters);
    }

    @Deprecated
    public InclusiveFilter(@NonNull Set<@NonNull Identifier> templateIds) {
        this(templateIds, Collections.emptyMap());
    }

    @Deprecated
    public InclusiveFilter(@NonNull Set<@NonNull Identifier> templateIds, @NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceIds) {
        this(templateIds, interfaceIds, Collections.emptyMap());
    }

    public static InclusiveFilter ofTemplateIds(@NonNull Set<@NonNull Identifier> templateIds) {
        return new InclusiveFilter(Collections.emptyMap(), templateIds.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), tId -> Filter.Template.HIDE_CREATED_EVENT_BLOB)));
    }

    public @NonNull Set<@NonNull Identifier> getTemplateIds() {
        return this.templateIds;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> getInterfaceFilters() {
        return this.interfaceFilters;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull Filter.Template> getTemplateFilters() {
        return this.templateFilters;
    }

    @Override
    public TransactionFilterOuterClass.Filters toProto() {
        ArrayList<ValueOuterClass.Identifier> templateIds = new ArrayList<ValueOuterClass.Identifier>(this.templateIds.size());
        for (Identifier identifier : this.templateIds) {
            templateIds.add(identifier.toProto());
        }
        TransactionFilterOuterClass.InclusiveFilters inclusiveFilter = TransactionFilterOuterClass.InclusiveFilters.newBuilder().addAllTemplateIds(templateIds).addAllInterfaceFilters(this.interfaceFilters.entrySet().stream().map(idFilt -> ((Filter.Interface)((Object)((Object)idFilt.getValue()))).toProto((Identifier)idFilt.getKey())).collect(Collectors.toUnmodifiableList())).addAllTemplateFilters(this.templateFilters.entrySet().stream().map(templateFilter -> ((Filter.Template)((Object)((Object)templateFilter.getValue()))).toProto((Identifier)templateFilter.getKey())).collect(Collectors.toUnmodifiableList())).build();
        return TransactionFilterOuterClass.Filters.newBuilder().setInclusive(inclusiveFilter).build();
    }

    public static InclusiveFilter fromProto(TransactionFilterOuterClass.InclusiveFilters inclusiveFilters) {
        HashSet<Identifier> templateIds = new HashSet<Identifier>(inclusiveFilters.getTemplateIdsCount());
        for (ValueOuterClass.Identifier templateId : inclusiveFilters.getTemplateIdsList()) {
            templateIds.add(Identifier.fromProto(templateId));
        }
        Map<Identifier, Filter.Interface> interfaceIds = inclusiveFilters.getInterfaceFiltersList().stream().collect(Collectors.toUnmodifiableMap(ifFilt -> Identifier.fromProto(ifFilt.getInterfaceId()), Filter.Interface::fromProto, Filter.Interface::merge));
        Map<Identifier, Filter.Template> templateFilters = inclusiveFilters.getTemplateFiltersList().stream().collect(Collectors.toUnmodifiableMap(templateFilter -> Identifier.fromProto(templateFilter.getTemplateId()), Filter.Template::fromProto, Filter.Template::merge));
        return new InclusiveFilter(templateIds, interfaceIds, templateFilters);
    }

    public String toString() {
        return "InclusiveFilter{templateIds=" + this.templateIds + ", interfaceFilters=" + this.interfaceFilters + ", templateFilters=" + this.templateFilters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InclusiveFilter that = (InclusiveFilter)o;
        return Objects.equals(this.templateIds, that.templateIds) && Objects.equals(this.interfaceFilters, that.interfaceFilters) && Objects.equals(this.templateFilters, that.templateFilters);
    }

    public int hashCode() {
        return Objects.hash(this.templateIds, this.interfaceFilters, this.templateFilters);
    }
}

