/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PackageVersion
implements Comparable<PackageVersion> {
    private final int[] segments;

    public PackageVersion(int[] segments) {
        this.segments = segments;
    }

    public static PackageVersion unsafeFromString(@NonNull String version) {
        String[] parts = version.split("\\.");
        int[] segments = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            segments[i] = Integer.parseInt(parts[i]);
            if (segments[i] >= 0) continue;
            throw new IllegalArgumentException("Invalid version. No negative segments allowed: " + version);
        }
        return new PackageVersion(segments);
    }

    @Override
    public int compareTo(PackageVersion other) {
        return Arrays.compare(this.segments, other.segments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageVersion that = (PackageVersion)o;
        return Arrays.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    public String toString() {
        return Arrays.stream(this.segments).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }
}

