/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.CommandsSubmission;
import com.daml.ledger.javaapi.data.DisclosedContract;
import com.daml.ledger.javaapi.data.PrefetchContractKey;
import com.daml.ledger.javaapi.data.codegen.HasCommands;
import com.google.protobuf.Duration;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SubmitCommandsRequest {
    private final String workflowId;
    private final String applicationId;
    private final String commandId;
    private final String party;
    private final List<String> actAs;
    private final List<String> readAs;
    private final Optional<Instant> minLedgerTimeAbsolute;
    private final Optional<java.time.Duration> minLedgerTimeRelative;
    private final Optional<java.time.Duration> deduplicationTime;
    private final Optional<String> submissionId;
    private final List<Command> commands;
    private final List<DisclosedContract> disclosedContracts;
    private final List<String> packageIdSelectionPreference;
    private final List<PrefetchContractKey> prefetchContractKeys;

    private SubmitCommandsRequest(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull Optional<String> submissionId, @NonNull List<@NonNull Command> commands, @NonNull List<@NonNull DisclosedContract> disclosedContracts, @NonNull List<@NonNull String> packageIdSelectionPreference, @NonNull List<@NonNull PrefetchContractKey> prefetchContractKeys) {
        if (actAs.isEmpty()) {
            throw new IllegalArgumentException("actAs must have at least one element");
        }
        this.workflowId = workflowId;
        this.applicationId = applicationId;
        this.commandId = commandId;
        this.party = actAs.get(0);
        this.actAs = List.copyOf(actAs);
        this.readAs = List.copyOf(readAs);
        this.minLedgerTimeAbsolute = minLedgerTimeAbsolute;
        this.minLedgerTimeRelative = minLedgerTimeRelative;
        this.deduplicationTime = deduplicationTime;
        this.submissionId = submissionId;
        this.commands = commands;
        this.disclosedContracts = disclosedContracts;
        this.packageIdSelectionPreference = packageIdSelectionPreference;
        this.prefetchContractKeys = prefetchContractKeys;
    }

    public static SubmitCommandsRequest fromProto(CommandsOuterClass.Commands commands) {
        String workflowId = commands.getWorkflowId();
        String applicationId = commands.getApplicationId();
        String commandId = commands.getCommandId();
        String party = commands.getParty();
        ProtocolStringList actAs = commands.getActAsList();
        ProtocolStringList readAs = commands.getReadAsList();
        List<DisclosedContract> disclosedContracts = commands.getDisclosedContractsList().stream().map(DisclosedContract::fromProto).collect(Collectors.toList());
        ProtocolStringList packageIdSelectionPreference = commands.getPackageIdSelectionPreferenceList();
        Optional<Instant> minLedgerTimeAbs = commands.hasMinLedgerTimeAbs() ? Optional.of(Instant.ofEpochSecond(commands.getMinLedgerTimeAbs().getSeconds(), commands.getMinLedgerTimeAbs().getNanos())) : Optional.empty();
        Optional<java.time.Duration> minLedgerTimeRel = commands.hasMinLedgerTimeRel() ? Optional.of(java.time.Duration.ofSeconds(commands.getMinLedgerTimeRel().getSeconds(), commands.getMinLedgerTimeRel().getNanos())) : Optional.empty();
        Optional<java.time.Duration> deduplicationPeriod = Optional.empty();
        switch (commands.getDeduplicationPeriodCase()) {
            case DEDUPLICATION_DURATION: {
                Duration d = commands.getDeduplicationDuration();
                deduplicationPeriod = Optional.of(java.time.Duration.ofSeconds(d.getSeconds(), d.getNanos()));
                break;
            }
            case DEDUPLICATION_TIME: {
                Duration t = commands.getDeduplicationTime();
                deduplicationPeriod = Optional.of(java.time.Duration.ofSeconds(t.getSeconds(), t.getNanos()));
                break;
            }
        }
        String submissionId = commands.getSubmissionId();
        ArrayList<Command> listOfCommands = new ArrayList<Command>(commands.getCommandsCount());
        for (CommandsOuterClass.Command command : commands.getCommandsList()) {
            listOfCommands.add(Command.fromProtoCommand(command));
        }
        if (!actAs.contains(party)) {
            actAs.add(0, party);
        }
        ArrayList<PrefetchContractKey> prefetchContractKeys = new ArrayList<PrefetchContractKey>(commands.getPrefetchContractKeysCount());
        for (CommandsOuterClass.PrefetchContractKey key : commands.getPrefetchContractKeysList()) {
            prefetchContractKeys.add(PrefetchContractKey.fromProto(key));
        }
        return new SubmitCommandsRequest(workflowId, applicationId, commandId, (List<String>)actAs, (List<String>)readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationPeriod, submissionId.isEmpty() ? Optional.empty() : Optional.of(submissionId), listOfCommands, disclosedContracts, (List<String>)packageIdSelectionPreference, prefetchContractKeys);
    }

    private static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull Optional<String> submissionId, @NonNull CommandsSubmission submission) {
        if (submission.getActAs().isEmpty()) {
            throw new IllegalArgumentException("actAs must have at least one element");
        }
        List<Command> commands = HasCommands.toCommands(submission.getCommands());
        List commandsConverted = commands.stream().map(Command::toProtoCommand).collect(Collectors.toList());
        List disclosedContracts = submission.getDisclosedContracts().stream().map(DisclosedContract::toProto).collect(Collectors.toList());
        List prefetchContractKeys = submission.getPrefetchContractKeys().stream().map(PrefetchContractKey::toProto).collect(Collectors.toList());
        CommandsOuterClass.Commands.Builder builder = CommandsOuterClass.Commands.newBuilder().setLedgerId(ledgerId).setApplicationId(submission.getApplicationId()).setCommandId(submission.getCommandId()).setParty(submission.getActAs().get(0)).addAllActAs(submission.getActAs()).addAllReadAs(submission.getReadAs()).addAllCommands(commandsConverted).addAllDisclosedContracts(disclosedContracts).addAllPackageIdSelectionPreference(submission.getPackageIdSelectionPreference()).addAllPrefetchContractKeys(prefetchContractKeys);
        submission.getMinLedgerTimeAbs().ifPresent(abs -> builder.setMinLedgerTimeAbs(Timestamp.newBuilder().setSeconds(abs.getEpochSecond()).setNanos(abs.getNano())));
        submission.getMinLedgerTimeRel().ifPresent(rel -> builder.setMinLedgerTimeRel(Duration.newBuilder().setSeconds(rel.getSeconds()).setNanos(rel.getNano())));
        submission.getDeduplicationTime().ifPresent(dedup -> {
            CommandsOuterClass.Commands.Builder unused = builder.setDeduplicationTime(Duration.newBuilder().setSeconds(dedup.getSeconds()).setNanos(dedup.getNano()));
        });
        submission.getWorkflowId().ifPresent(builder::setWorkflowId);
        submissionId.ifPresent(builder::setSubmissionId);
        return builder.build();
    }

    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull CommandsSubmission submission) {
        return SubmitCommandsRequest.toProto(ledgerId, Optional.empty(), submission);
    }

    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String submissionId, @NonNull CommandsSubmission submission) {
        return SubmitCommandsRequest.toProto(ledgerId, Optional.of(submissionId), submission);
    }

    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull String getApplicationId() {
        return this.applicationId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull String getParty() {
        return this.party;
    }

    public @NonNull List<String> getActAs() {
        return this.actAs;
    }

    public @NonNull List<String> getReadAs() {
        return this.readAs;
    }

    public @NonNull Optional<Instant> getMinLedgerTimeAbsolute() {
        return this.minLedgerTimeAbsolute;
    }

    public @NonNull Optional<java.time.Duration> getMinLedgerTimeRelative() {
        return this.minLedgerTimeRelative;
    }

    public @NonNull Optional<java.time.Duration> getDeduplicationTime() {
        return this.deduplicationTime;
    }

    public @NonNull Optional<String> getSubmissionId() {
        return this.submissionId;
    }

    public @NonNull List<@NonNull Command> getCommands() {
        return this.commands;
    }

    public @NonNull List<@NonNull DisclosedContract> getDisclosedContracts() {
        return this.disclosedContracts;
    }

    public @NonNull List<@NonNull String> getPackageIdSelectionPreference() {
        return Collections.unmodifiableList(this.packageIdSelectionPreference);
    }

    public @NonNull List<@NonNull PrefetchContractKey> getPrefetchContractKeys() {
        return Collections.unmodifiableList(this.prefetchContractKeys);
    }

    public String toString() {
        return "SubmitCommandsRequest{workflowId='" + this.workflowId + "', applicationId='" + this.applicationId + "', commandId='" + this.commandId + "', party='" + this.party + "', minLedgerTimeAbs=" + this.minLedgerTimeAbsolute + ", minLedgerTimeRel=" + this.minLedgerTimeRelative + ", deduplicationTime=" + this.deduplicationTime + ", submissionId=" + this.submissionId + ", commands=" + this.commands + ", disclosedContracts=" + this.disclosedContracts + ", packageIdSelectionPreference=" + this.packageIdSelectionPreference + ", prefetchContractKeys=" + this.prefetchContractKeys + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitCommandsRequest submitCommandsRequest1 = (SubmitCommandsRequest)o;
        return Objects.equals(this.workflowId, submitCommandsRequest1.workflowId) && Objects.equals(this.applicationId, submitCommandsRequest1.applicationId) && Objects.equals(this.commandId, submitCommandsRequest1.commandId) && Objects.equals(this.party, submitCommandsRequest1.party) && Objects.equals(this.actAs, submitCommandsRequest1.actAs) && Objects.equals(this.readAs, submitCommandsRequest1.readAs) && Objects.equals(this.minLedgerTimeAbsolute, submitCommandsRequest1.minLedgerTimeAbsolute) && Objects.equals(this.minLedgerTimeRelative, submitCommandsRequest1.minLedgerTimeRelative) && Objects.equals(this.deduplicationTime, submitCommandsRequest1.deduplicationTime) && Objects.equals(this.submissionId, submitCommandsRequest1.submissionId) && Objects.equals(this.commands, submitCommandsRequest1.commands) && Objects.equals(this.disclosedContracts, submitCommandsRequest1.disclosedContracts) && Objects.equals(this.packageIdSelectionPreference, submitCommandsRequest1.packageIdSelectionPreference);
    }

    public int hashCode() {
        return Objects.hash(this.workflowId, this.applicationId, this.commandId, this.party, this.actAs, this.readAs, this.minLedgerTimeAbsolute, this.minLedgerTimeRelative, this.deduplicationTime, this.submissionId, this.commands, this.disclosedContracts, this.packageIdSelectionPreference);
    }
}

