/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.javaapi.data.CommandsSubmission;
import com.daml.ledger.javaapi.data.DisclosedContract;
import com.daml.ledger.javaapi.data.PrefetchContractKey;
import com.daml.ledger.javaapi.data.codegen.Update;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UpdateSubmission<U> {
    private String applicationId;
    private String commandId;
    private Update<U> update;
    private Optional<String> workflowId;
    private List<@NonNull String> actAs;
    private List<@NonNull String> readAs;
    private Optional<Instant> minLedgerTimeAbs;
    private Optional<Duration> minLedgerTimeRel;
    private Optional<Duration> deduplicationTime;
    private Optional<String> accessToken;
    private List<DisclosedContract> disclosedContracts;
    private List<String> packageIdSelectionPreference;
    private List<@NonNull PrefetchContractKey> prefetchContractKeys;

    private UpdateSubmission(String applicationId, String commandId, Update<U> update, List<@NonNull String> actAs, List<@NonNull String> readAs, Optional<String> workflowId, Optional<Instant> minLedgerTimeAbs, Optional<Duration> minLedgerTimeRel, Optional<Duration> deduplicationTime, Optional<String> accessToken, List<@NonNull DisclosedContract> disclosedContracts, List<@NonNull String> packageIdSelectionPreference, List<@NonNull PrefetchContractKey> prefetchContractKeys) {
        this.workflowId = workflowId;
        this.applicationId = applicationId;
        this.commandId = commandId;
        this.actAs = actAs;
        this.readAs = readAs;
        this.minLedgerTimeAbs = minLedgerTimeAbs;
        this.minLedgerTimeRel = minLedgerTimeRel;
        this.deduplicationTime = deduplicationTime;
        this.update = update;
        this.accessToken = accessToken;
        this.disclosedContracts = disclosedContracts;
        this.packageIdSelectionPreference = packageIdSelectionPreference;
        this.prefetchContractKeys = prefetchContractKeys;
    }

    public static <U> UpdateSubmission<U> create(String applicationId, String commandId, Update<U> update) {
        return new UpdateSubmission<U>(applicationId, commandId, update, Collections.emptyList(), Collections.emptyList(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public Optional<String> getWorkflowId() {
        return this.workflowId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public List<String> getActAs() {
        return Collections.unmodifiableList(this.actAs);
    }

    public List<String> getReadAs() {
        return Collections.unmodifiableList(this.readAs);
    }

    public Optional<Instant> getMinLedgerTimeAbs() {
        return this.minLedgerTimeAbs;
    }

    public Optional<Duration> getMinLedgerTimeRel() {
        return this.minLedgerTimeRel;
    }

    public Optional<Duration> getDeduplicationTime() {
        return this.deduplicationTime;
    }

    public Update<U> getUpdate() {
        return this.update;
    }

    public Optional<String> getAccessToken() {
        return this.accessToken;
    }

    public List<DisclosedContract> getDisclosedContracts() {
        return Collections.unmodifiableList(this.disclosedContracts);
    }

    public List<String> getPackageIdSelectionPreference() {
        return Collections.unmodifiableList(this.packageIdSelectionPreference);
    }

    public List<PrefetchContractKey> getPrefetchContractKeys() {
        return Collections.unmodifiableList(this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withWorkflowId(String workflowId) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, Optional.of(workflowId), this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withActAs(String actAs) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, List.of(actAs), this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withActAs(List<@NonNull String> actAs) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withReadAs(List<@NonNull String> readAs) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withMinLedgerTimeAbs(Optional<Instant> minLedgerTimeAbs) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withMinLedgerTimeRel(Optional<Duration> minLedgerTimeRel) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withDeduplicationTime(Optional<Duration> deduplicationTime) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withAccessToken(Optional<String> accessToken) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withDisclosedContracts(List<@NonNull DisclosedContract> disclosedContracts) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withPackageIdSelectionPreference(List<@NonNull String> packageIdSelectionPreference) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, packageIdSelectionPreference, this.prefetchContractKeys);
    }

    public UpdateSubmission<U> withPrefetchContractKeys(List<PrefetchContractKey> prefetchContractKeys) {
        return new UpdateSubmission<U>(this.applicationId, this.commandId, this.update, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, prefetchContractKeys);
    }

    public CommandsSubmission toCommandsSubmission() {
        return new CommandsSubmission(this.applicationId, this.commandId, this.update.commands(), this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken, this.disclosedContracts, this.packageIdSelectionPreference, this.prefetchContractKeys);
    }
}

