/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen.json;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;

public class JsonLfWriter {
    private final Writer writer;
    private final Options options;

    public JsonLfWriter(Writer w, Options options) {
        this.writer = w;
        this.options = options;
    }

    public JsonLfWriter(Writer w) {
        this(w, JsonLfWriter.opts());
    }

    void writeStartObject() throws IOException {
        this.write("{");
    }

    void writeEndObject() throws IOException {
        this.write("}");
    }

    void writeFieldName(String name) throws IOException {
        this.write(this.quoted(name) + ": ");
    }

    void writeStartArray() throws IOException {
        this.write("[");
    }

    void writeEndArray() throws IOException {
        this.write("]");
    }

    void writeComma() throws IOException {
        this.write(", ");
    }

    void write(String value) throws IOException {
        this.writer.write(value);
    }

    void writeNumeric(BigDecimal num) throws IOException {
        if (this.options.encodeNumericAsString) {
            this.writer.write(this.quoted(num));
        } else {
            this.writer.write(num.toString());
        }
    }

    void writeInt64(Long num) throws IOException {
        if (this.options.encodeInt64AsString) {
            this.writer.write(this.quoted(num));
        } else {
            this.writer.write(num.toString());
        }
    }

    private String quoted(Object val) {
        return "\"" + val.toString() + "\"";
    }

    public static Options opts() {
        return new Options(true, true);
    }

    public static final class Options {
        public final boolean encodeNumericAsString;
        public final boolean encodeInt64AsString;

        public Options encodeNumericAsString(boolean encodeNumericAsString) {
            return new Options(encodeNumericAsString, this.encodeInt64AsString);
        }

        public Options encodeInt64AsString(boolean encodeInt64AsString) {
            return new Options(this.encodeNumericAsString, encodeInt64AsString);
        }

        private Options(boolean encodeNumericAsString, boolean encodeInt64AsString) {
            this.encodeNumericAsString = encodeNumericAsString;
            this.encodeInt64AsString = encodeInt64AsString;
        }
    }
}

