/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExerciseCommand
extends Command {
    private final Identifier templateId;
    private final String contractId;
    private final String choice;
    private final Value choiceArgument;

    public ExerciseCommand(@NonNull Identifier templateId, @NonNull String contractId, @NonNull String choice, @NonNull Value choiceArgument) {
        this.templateId = templateId;
        this.contractId = contractId;
        this.choice = choice;
        this.choiceArgument = choiceArgument;
    }

    public static ExerciseCommand fromProto(CommandsOuterClass.ExerciseCommand command) {
        Identifier templateId = Identifier.fromProto(command.getTemplateId());
        String contractId = command.getContractId();
        String choice = command.getChoice();
        Value choiceArgument = Value.fromProto(command.getChoiceArgument());
        return new ExerciseCommand(templateId, contractId, choice, choiceArgument);
    }

    public CommandsOuterClass.ExerciseCommand toProto() {
        return CommandsOuterClass.ExerciseCommand.newBuilder().setTemplateId(this.templateId.toProto()).setContractId(this.contractId).setChoice(this.choice).setChoiceArgument(this.choiceArgument.toProto()).build();
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull String getChoice() {
        return this.choice;
    }

    public @NonNull Value getChoiceArgument() {
        return this.choiceArgument;
    }

    public String toString() {
        return "ExerciseCommand{templateId=" + this.templateId + ", contractId='" + this.contractId + "', choice='" + this.choice + "', choiceArgument=" + this.choiceArgument + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExerciseCommand that = (ExerciseCommand)o;
        return Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.choice, that.choice) && Objects.equals(this.choiceArgument, that.choiceArgument);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.contractId, this.choice, this.choiceArgument);
    }
}

