/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionOuterClass;
import com.daml.ledger.javaapi.data.TreeEvent;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TransactionTree {
    private final String transactionId;
    private final String commandId;
    private final String workflowId;
    private final Instant effectiveAt;
    private final Map<String, TreeEvent> eventsById;
    private final List<String> rootEventIds;
    private final String offset;

    public TransactionTree(@NonNull String transactionId, @NonNull String commandId, @NonNull String workflowId, @NonNull Instant effectiveAt, @NonNull Map<@NonNull String, @NonNull TreeEvent> eventsById, List<String> rootEventIds, @NonNull String offset) {
        this.transactionId = transactionId;
        this.commandId = commandId;
        this.workflowId = workflowId;
        this.effectiveAt = effectiveAt;
        this.eventsById = eventsById;
        this.rootEventIds = rootEventIds;
        this.offset = offset;
    }

    public static TransactionTree fromProto(TransactionOuterClass.TransactionTree tree) {
        String transactionId = tree.getTransactionId();
        String commandId = tree.getCommandId();
        String workflowId = tree.getWorkflowId();
        Instant effectiveAt = Instant.ofEpochSecond(tree.getEffectiveAt().getSeconds(), tree.getEffectiveAt().getNanos());
        Map<String, TreeEvent> eventsById = tree.getEventsByIdMap().values().stream().collect(Collectors.toMap(e -> {
            if (e.hasCreated()) {
                return e.getCreated().getEventId();
            }
            if (e.hasExercised()) {
                return e.getExercised().getEventId();
            }
            throw new IllegalArgumentException("Event is neither created not exercied: " + e);
        }, TreeEvent::fromProtoTreeEvent));
        ProtocolStringList rootEventIds = tree.getRootEventIdsList();
        String offset = tree.getOffset();
        return new TransactionTree(transactionId, commandId, workflowId, effectiveAt, eventsById, (List<String>)rootEventIds, offset);
    }

    public TransactionOuterClass.TransactionTree toProto() {
        return TransactionOuterClass.TransactionTree.newBuilder().setTransactionId(this.transactionId).setCommandId(this.commandId).setWorkflowId(this.workflowId).setEffectiveAt(Timestamp.newBuilder().setSeconds(this.effectiveAt.getEpochSecond()).setNanos(this.effectiveAt.getNano()).build()).putAllEventsById(this.eventsById.values().stream().collect(Collectors.toMap(TreeEvent::getEventId, TreeEvent::toProtoTreeEvent))).addAllRootEventIds(this.rootEventIds).setOffset(this.offset).build();
    }

    public @NonNull String getTransactionId() {
        return this.transactionId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull Instant getEffectiveAt() {
        return this.effectiveAt;
    }

    public @NonNull Map<String, TreeEvent> getEventsById() {
        return this.eventsById;
    }

    public @NonNull List<String> getRootEventIds() {
        return this.rootEventIds;
    }

    public @NonNull String getOffset() {
        return this.offset;
    }

    public String toString() {
        return "TransactionTree{transactionId='" + this.transactionId + "', commandId='" + this.commandId + "', workflowId='" + this.workflowId + "', effectiveAt=" + this.effectiveAt + ", eventsById=" + this.eventsById + ", rootEventIds=" + this.rootEventIds + ", offset='" + this.offset + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionTree that = (TransactionTree)o;
        return Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.commandId, that.commandId) && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.effectiveAt, that.effectiveAt) && Objects.equals(this.eventsById, that.eventsById) && Objects.equals(this.rootEventIds, that.rootEventIds) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.commandId, this.workflowId, this.effectiveAt, this.eventsById, this.rootEventIds, this.offset);
    }
}

