/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandCompletionServiceOuterClass;
import com.daml.ledger.javaapi.data.LedgerOffset;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Checkpoint {
    private final Instant recordTime;
    private final LedgerOffset offset;

    public Checkpoint(@NonNull Instant recordTime, @NonNull LedgerOffset offset) {
        this.recordTime = recordTime;
        this.offset = offset;
    }

    public static Checkpoint fromProto(CommandCompletionServiceOuterClass.Checkpoint checkpoint) {
        LedgerOffset offset = LedgerOffset.fromProto(checkpoint.getOffset());
        return new Checkpoint(Instant.ofEpochSecond(checkpoint.getRecordTime().getSeconds(), checkpoint.getRecordTime().getNanos()), offset);
    }

    public CommandCompletionServiceOuterClass.Checkpoint toProto() {
        return CommandCompletionServiceOuterClass.Checkpoint.newBuilder().setRecordTime(Timestamp.newBuilder().setSeconds(this.recordTime.getEpochSecond()).setNanos(this.recordTime.getNano()).build()).setOffset(this.offset.toProto()).build();
    }

    public @NonNull Instant getRecordTime() {
        return this.recordTime;
    }

    public @NonNull LedgerOffset getOffset() {
        return this.offset;
    }

    public String toString() {
        return "Checkpoint{recordTime=" + this.recordTime + ", offset=" + this.offset + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        return Objects.equals(this.recordTime, that.recordTime) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.recordTime, this.offset);
    }
}

