package com.daml.ledger.api.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
 * information with each tracking result. This supports the implementation of stateless clients.
 * Note that submitted commands generally produce completion events as well, even in case a command gets rejected.
 * For example, the participant MAY choose to produce a completion event for a rejection of a duplicate command.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/command_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class CommandServiceGrpc {

  private CommandServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.CommandService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.google.protobuf.Empty> getSubmitAndWaitMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWait",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.google.protobuf.Empty> getSubmitAndWaitMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.google.protobuf.Empty> getSubmitAndWaitMethod;
    if ((getSubmitAndWaitMethod = CommandServiceGrpc.getSubmitAndWaitMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitMethod = CommandServiceGrpc.getSubmitAndWaitMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitMethod = getSubmitAndWaitMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SubmitAndWait"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWait"))
              .build();
        }
      }
    }
    return getSubmitAndWaitMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> getSubmitAndWaitForTransactionIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWaitForTransactionId",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> getSubmitAndWaitForTransactionIdMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> getSubmitAndWaitForTransactionIdMethod;
    if ((getSubmitAndWaitForTransactionIdMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionIdMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitForTransactionIdMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionIdMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitForTransactionIdMethod = getSubmitAndWaitForTransactionIdMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SubmitAndWaitForTransactionId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse.getDefaultInstance()))
              .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWaitForTransactionId"))
              .build();
        }
      }
    }
    return getSubmitAndWaitForTransactionIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> getSubmitAndWaitForTransactionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWaitForTransaction",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> getSubmitAndWaitForTransactionMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> getSubmitAndWaitForTransactionMethod;
    if ((getSubmitAndWaitForTransactionMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitForTransactionMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitForTransactionMethod = getSubmitAndWaitForTransactionMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SubmitAndWaitForTransaction"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWaitForTransaction"))
              .build();
        }
      }
    }
    return getSubmitAndWaitForTransactionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> getSubmitAndWaitForTransactionTreeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SubmitAndWaitForTransactionTree",
      requestType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.class,
      responseType = com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
      com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> getSubmitAndWaitForTransactionTreeMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> getSubmitAndWaitForTransactionTreeMethod;
    if ((getSubmitAndWaitForTransactionTreeMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionTreeMethod) == null) {
      synchronized (CommandServiceGrpc.class) {
        if ((getSubmitAndWaitForTransactionTreeMethod = CommandServiceGrpc.getSubmitAndWaitForTransactionTreeMethod) == null) {
          CommandServiceGrpc.getSubmitAndWaitForTransactionTreeMethod = getSubmitAndWaitForTransactionTreeMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest, com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SubmitAndWaitForTransactionTree"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new CommandServiceMethodDescriptorSupplier("SubmitAndWaitForTransactionTree"))
              .build();
        }
      }
    }
    return getSubmitAndWaitForTransactionTreeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static CommandServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<CommandServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<CommandServiceStub>() {
        @java.lang.Override
        public CommandServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new CommandServiceStub(channel, callOptions);
        }
      };
    return CommandServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static CommandServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<CommandServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<CommandServiceBlockingStub>() {
        @java.lang.Override
        public CommandServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new CommandServiceBlockingStub(channel, callOptions);
        }
      };
    return CommandServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static CommandServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<CommandServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<CommandServiceFutureStub>() {
        @java.lang.Override
        public CommandServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new CommandServiceFutureStub(channel, callOptions);
        }
      };
    return CommandServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * Note that submitted commands generally produce completion events as well, even in case a command gets rejected.
   * For example, the participant MAY choose to produce a completion event for a rejection of a duplicate command.
   * </pre>
   */
  public static abstract class CommandServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWait(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSubmitAndWaitMethod(), responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWaitForTransactionId(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSubmitAndWaitForTransactionIdMethod(), responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWaitForTransaction(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSubmitAndWaitForTransactionMethod(), responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWaitForTransactionTree(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSubmitAndWaitForTransactionTreeMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getSubmitAndWaitMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_SUBMIT_AND_WAIT)))
          .addMethod(
            getSubmitAndWaitForTransactionIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse>(
                  this, METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_ID)))
          .addMethod(
            getSubmitAndWaitForTransactionMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse>(
                  this, METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION)))
          .addMethod(
            getSubmitAndWaitForTransactionTreeMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest,
                com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse>(
                  this, METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_TREE)))
          .build();
    }
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * Note that submitted commands generally produce completion events as well, even in case a command gets rejected.
   * For example, the participant MAY choose to produce a completion event for a rejection of a duplicate command.
   * </pre>
   */
  public static final class CommandServiceStub extends io.grpc.stub.AbstractAsyncStub<CommandServiceStub> {
    private CommandServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new CommandServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWait(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWaitForTransactionId(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWaitForTransaction(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public void submitAndWaitForTransactionTree(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionTreeMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * Note that submitted commands generally produce completion events as well, even in case a command gets rejected.
   * For example, the participant MAY choose to produce a completion event for a rejection of a duplicate command.
   * </pre>
   */
  public static final class CommandServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<CommandServiceBlockingStub> {
    private CommandServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new CommandServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.google.protobuf.Empty submitAndWait(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSubmitAndWaitMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse submitAndWaitForTransactionId(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSubmitAndWaitForTransactionIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse submitAndWaitForTransaction(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSubmitAndWaitForTransactionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse submitAndWaitForTransactionTree(com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSubmitAndWaitForTransactionTreeMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
   * information with each tracking result. This supports the implementation of stateless clients.
   * Note that submitted commands generally produce completion events as well, even in case a command gets rejected.
   * For example, the participant MAY choose to produce a completion event for a rejection of a duplicate command.
   * </pre>
   */
  public static final class CommandServiceFutureStub extends io.grpc.stub.AbstractFutureStub<CommandServiceFutureStub> {
    private CommandServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CommandServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new CommandServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Submits a single composite command and waits for its result.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> submitAndWait(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction id.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse> submitAndWaitForTransactionId(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse> submitAndWaitForTransaction(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Submits a single composite command, waits for its result, and returns the transaction tree.
     * Propagates the gRPC error of failed submissions including Daml interpretation errors.
     * Errors:
     * - ``UNAUTHENTICATED``: if the request does not include a valid access token
     * - ``PERMISSION_DENIED``: if the claims in the token are insufficient to perform a given operation
     * - ``NOT_FOUND``: if the request does not include a valid ledger id or if a resource is missing (e.g. contract key)
     * due to for example contention on resources
     * - ``ALREADY_EXISTS`` if a resource is duplicated (e.g. contract key)
     * - ``INVALID_ARGUMENT``: if the payload is malformed or is missing required fields
     * - ``ABORTED``: if the number of in-flight commands reached the maximum (if a limit is configured)
     * - ``FAILED_PRECONDITION``: on consistency errors (e.g. the contract key has changed since the submission)
     * or if an interpretation error occurred
     * - ``UNAVAILABLE``: if the participant is not yet ready to submit commands or if the service has been shut down.
     * - ``DEADLINE_EXCEEDED``: if the request failed to receive its completion within the predefined timeout.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse> submitAndWaitForTransactionTree(
        com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSubmitAndWaitForTransactionTreeMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_SUBMIT_AND_WAIT = 0;
  private static final int METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_ID = 1;
  private static final int METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION = 2;
  private static final int METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_TREE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final CommandServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(CommandServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_SUBMIT_AND_WAIT:
          serviceImpl.submitAndWait((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_ID:
          serviceImpl.submitAndWaitForTransactionId((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse>) responseObserver);
          break;
        case METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION:
          serviceImpl.submitAndWaitForTransaction((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionResponse>) responseObserver);
          break;
        case METHODID_SUBMIT_AND_WAIT_FOR_TRANSACTION_TREE:
          serviceImpl.submitAndWaitForTransactionTree((com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class CommandServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    CommandServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.CommandServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("CommandService");
    }
  }

  private static final class CommandServiceFileDescriptorSupplier
      extends CommandServiceBaseDescriptorSupplier {
    CommandServiceFileDescriptorSupplier() {}
  }

  private static final class CommandServiceMethodDescriptorSupplier
      extends CommandServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    CommandServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (CommandServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new CommandServiceFileDescriptorSupplier())
              .addMethod(getSubmitAndWaitMethod())
              .addMethod(getSubmitAndWaitForTransactionIdMethod())
              .addMethod(getSubmitAndWaitForTransactionMethod())
              .addMethod(getSubmitAndWaitForTransactionTreeMethod())
              .build();
        }
      }
    }
    return result;
  }
}
