package com.daml.ledger.api.v1.testing;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Optional service, exposed for testing static time scenarios.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: com/daml/ledger/api/v1/testing/time_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class TimeServiceGrpc {

  private TimeServiceGrpc() {}

  public static final String SERVICE_NAME = "com.daml.ledger.api.v1.testing.TimeService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest,
      com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse> getGetTimeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTime",
      requestType = com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest.class,
      responseType = com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest,
      com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse> getGetTimeMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest, com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse> getGetTimeMethod;
    if ((getGetTimeMethod = TimeServiceGrpc.getGetTimeMethod) == null) {
      synchronized (TimeServiceGrpc.class) {
        if ((getGetTimeMethod = TimeServiceGrpc.getGetTimeMethod) == null) {
          TimeServiceGrpc.getGetTimeMethod = getGetTimeMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest, com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetTime"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TimeServiceMethodDescriptorSupplier("GetTime"))
              .build();
        }
      }
    }
    return getGetTimeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest,
      com.google.protobuf.Empty> getSetTimeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SetTime",
      requestType = com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest,
      com.google.protobuf.Empty> getSetTimeMethod() {
    io.grpc.MethodDescriptor<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest, com.google.protobuf.Empty> getSetTimeMethod;
    if ((getSetTimeMethod = TimeServiceGrpc.getSetTimeMethod) == null) {
      synchronized (TimeServiceGrpc.class) {
        if ((getSetTimeMethod = TimeServiceGrpc.getSetTimeMethod) == null) {
          TimeServiceGrpc.getSetTimeMethod = getSetTimeMethod =
              io.grpc.MethodDescriptor.<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SetTime"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new TimeServiceMethodDescriptorSupplier("SetTime"))
              .build();
        }
      }
    }
    return getSetTimeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TimeServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TimeServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TimeServiceStub>() {
        @java.lang.Override
        public TimeServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TimeServiceStub(channel, callOptions);
        }
      };
    return TimeServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TimeServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TimeServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TimeServiceBlockingStub>() {
        @java.lang.Override
        public TimeServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TimeServiceBlockingStub(channel, callOptions);
        }
      };
    return TimeServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TimeServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TimeServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TimeServiceFutureStub>() {
        @java.lang.Override
        public TimeServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TimeServiceFutureStub(channel, callOptions);
        }
      };
    return TimeServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Optional service, exposed for testing static time scenarios.
   * </pre>
   */
  public static abstract class TimeServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Returns a stream of time updates.
     * Always returns at least one response, where the first one is the current time.
     * Subsequent responses are emitted whenever the ledger server's time is updated.
     * </pre>
     */
    public void getTime(com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetTimeMethod(), responseObserver);
    }

    /**
     * <pre>
     * Allows clients to change the ledger's clock in an atomic get-and-set operation.
     * Errors:
     * - ``INVALID_ARGUMENT``: if ``current_time`` is invalid (it MUST precisely match the current time as it's known to the ledger server)
     * </pre>
     */
    public void setTime(com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSetTimeMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getGetTimeMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest,
                com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse>(
                  this, METHODID_GET_TIME)))
          .addMethod(
            getSetTimeMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_SET_TIME)))
          .build();
    }
  }

  /**
   * <pre>
   * Optional service, exposed for testing static time scenarios.
   * </pre>
   */
  public static final class TimeServiceStub extends io.grpc.stub.AbstractAsyncStub<TimeServiceStub> {
    private TimeServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TimeServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TimeServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns a stream of time updates.
     * Always returns at least one response, where the first one is the current time.
     * Subsequent responses are emitted whenever the ledger server's time is updated.
     * </pre>
     */
    public void getTime(com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest request,
        io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getGetTimeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Allows clients to change the ledger's clock in an atomic get-and-set operation.
     * Errors:
     * - ``INVALID_ARGUMENT``: if ``current_time`` is invalid (it MUST precisely match the current time as it's known to the ledger server)
     * </pre>
     */
    public void setTime(com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSetTimeMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Optional service, exposed for testing static time scenarios.
   * </pre>
   */
  public static final class TimeServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<TimeServiceBlockingStub> {
    private TimeServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TimeServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TimeServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns a stream of time updates.
     * Always returns at least one response, where the first one is the current time.
     * Subsequent responses are emitted whenever the ledger server's time is updated.
     * </pre>
     */
    public java.util.Iterator<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse> getTime(
        com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getGetTimeMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Allows clients to change the ledger's clock in an atomic get-and-set operation.
     * Errors:
     * - ``INVALID_ARGUMENT``: if ``current_time`` is invalid (it MUST precisely match the current time as it's known to the ledger server)
     * </pre>
     */
    public com.google.protobuf.Empty setTime(com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSetTimeMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Optional service, exposed for testing static time scenarios.
   * </pre>
   */
  public static final class TimeServiceFutureStub extends io.grpc.stub.AbstractFutureStub<TimeServiceFutureStub> {
    private TimeServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TimeServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TimeServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Allows clients to change the ledger's clock in an atomic get-and-set operation.
     * Errors:
     * - ``INVALID_ARGUMENT``: if ``current_time`` is invalid (it MUST precisely match the current time as it's known to the ledger server)
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> setTime(
        com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSetTimeMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_TIME = 0;
  private static final int METHODID_SET_TIME = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final TimeServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(TimeServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_TIME:
          serviceImpl.getTime((com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeRequest) request,
              (io.grpc.stub.StreamObserver<com.daml.ledger.api.v1.testing.TimeServiceOuterClass.GetTimeResponse>) responseObserver);
          break;
        case METHODID_SET_TIME:
          serviceImpl.setTime((com.daml.ledger.api.v1.testing.TimeServiceOuterClass.SetTimeRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class TimeServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TimeServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.daml.ledger.api.v1.testing.TimeServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("TimeService");
    }
  }

  private static final class TimeServiceFileDescriptorSupplier
      extends TimeServiceBaseDescriptorSupplier {
    TimeServiceFileDescriptorSupplier() {}
  }

  private static final class TimeServiceMethodDescriptorSupplier
      extends TimeServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    TimeServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TimeServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TimeServiceFileDescriptorSupplier())
              .addMethod(getGetTimeMethod())
              .addMethod(getSetTimeMethod())
              .build();
        }
      }
    }
    return result;
  }
}
